/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SourceCodeFormatter
implements Appendable,
CharSequence {
    private final int indentSpaces;
    private final AtomicInteger indent;
    private final StringBuilder response = new StringBuilder();
    private StringBuilder sb = new StringBuilder();

    public SourceCodeFormatter(int indentSpaces, AtomicInteger indent) {
        this.indentSpaces = indentSpaces;
        this.indent = indent;
    }

    public SourceCodeFormatter(int indentSpaces) {
        this.indentSpaces = indentSpaces;
        this.indent = new AtomicInteger(0);
    }

    public SourceCodeFormatter(int indentSpaces, int i) {
        this.indentSpaces = indentSpaces;
        this.indent = new AtomicInteger(i);
    }

    @Override
    @NotNull
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq) {
        this.sb.append(this.replaceNewLine(csq, 0, csq.length() - 1));
        return this;
    }

    private CharSequence replaceNewLine(CharSequence csq, int start, int end) {
        this.response.setLength(0);
        boolean lastChargeWasNewLine = false;
        int lastNewlineIndex = 0;
        block6: for (int i = start; i <= end; ++i) {
            char c = csq.charAt(i);
            this.response.append(c);
            switch (c) {
                case '\n': {
                    lastNewlineIndex = this.response.length();
                    lastChargeWasNewLine = true;
                    this.padding(this.response, this.indent.get());
                    continue block6;
                }
                case '{': {
                    this.indent.incrementAndGet();
                    continue block6;
                }
                case '}': {
                    this.indent.decrementAndGet();
                    if (lastNewlineIndex < 0) continue block6;
                    this.response.setLength(lastNewlineIndex);
                    this.padding(this.response, this.indent.get());
                    this.response.append(c);
                    continue block6;
                }
                case ' ': {
                    if (!lastChargeWasNewLine) continue block6;
                    this.response.setLength(this.response.length() - 1);
                    continue block6;
                }
                default: {
                    lastChargeWasNewLine = false;
                }
            }
        }
        return this.response;
    }

    public void setLength(int len) {
        this.sb.setLength(len);
    }

    private void padding(StringBuilder target, int indent) {
        for (int i = 0; i < indent * this.indentSpaces; ++i) {
            target.append(' ');
        }
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq, int start, int end) {
        this.sb.append(this.replaceNewLine(csq, start, end), start, end);
        return this;
    }

    @Override
    public SourceCodeFormatter append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }
}

