/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleCQFormatTest
extends ChronicleQueueTestBase {
    private ThreadDump threadDump;

    @Test
    public void testEmptyDirectory() {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();){
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.firstCycle());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)queue.lastCycle());
        }
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    @Test
    public void testInvalidFile() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)65536L);){
            bytes.write8bit("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize().build();){
                Assert.assertEquals((long)1L, (long)queue.firstCycle());
                Assert.assertEquals((long)1L, (long)queue.lastCycle());
                try {
                    ExcerptTailer tailer = queue.createTailer();
                    tailer.toEnd();
                    Assert.fail();
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"java.io.StreamCorruptedException: Unexpected magic number 783f3c37", (Object)e.toString());
                }
            }
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoHeader() throws IOException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        File file = new File(dir, "19700101.cq4");
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] bytes = new byte[1024];
            for (int i = 0; i < 128; ++i) {
                fos.write(bytes);
            }
        }
        try {
            var4_5 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).timeoutMS(500L).testBlockSize().build();){
                this.testQueue((ChronicleQueue)queue);
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadHeader() throws IOException {
        File dir = this.getTmpDir();
        dir.mkdirs();
        File file = new File(dir, "19700101.cq4");
        file.createNewFile();
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        try {
            bytes.writeInt(-1073741824);
        }
        finally {
            bytes.releaseLast();
        }
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).timeoutMS(500L).testBlockSize().blockSize(65536).build();){
            this.testQueue((ChronicleQueue)queue);
        }
        finally {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
    }

    private void testQueue(@NotNull ChronicleQueue queue) {
        try (ExcerptTailer tailer = queue.createTailer();
             DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
    }

    @Test
    public void testCompleteHeader() throws FileNotFoundException {
        AbstractCloseable.disableCloseableTracing();
        File dir = this.getTmpDir();
        dir.mkdirs();
        File file = new File(dir, "19700101.cq4");
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)131072L);){
            BinaryWire wire = new BinaryWire((Bytes)bytes);
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().writeEventName((CharSequence)"header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                    w.write((CharSequence)"wireType").object((Object)WireType.BINARY);
                    w.write((CharSequence)"writePosition").int64forBinding(0L);
                    w.write((CharSequence)"roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)RollCycles.TEST4_DAILY, 0L, null, null));
                    w.write((CharSequence)"indexing").typedMarshallable((WriteMarshallable)new SCQIndexing(WireType.BINARY, 32, 4));
                    w.write((CharSequence)"lastAcknowledgedIndexReplicated").int64forBinding(0L);
                });
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd'T4',\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        }
        var4_5 = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize().build();){
            this.testQueue((ChronicleQueue)queue);
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCompleteHeader2() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101-02.cq4"), (long)131072L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (SingleChronicleQueueStore store = new SingleChronicleQueueStore((RollCycle)RollCycles.HOURLY, WireType.BINARY, bytes, 4096, 4);){
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().write((CharSequence)"header").typedMarshallable((WriteMarshallable)store);
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: !short 4096,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  dataFormat: 1\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        }
        var5_6 = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.HOURLY).build();){
            this.testQueue((ChronicleQueue)queue);
            Assert.assertEquals((long)2L, (long)queue.firstCycle());
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncompleteHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)65536L);){
            BinaryWire wire = new BinaryWire((Bytes)bytes);
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().writeEventName((CharSequence)"header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> w.write((CharSequence)"wireType").object((Object)WireType.BINARY));
            }
        }
        try {
            var3_5 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).blockSize(65536).build();){
                this.testQueue((ChronicleQueue)queue);
                Assert.fail();
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.IORuntimeException: net.openhft.chronicle.core.io.IORuntimeException: field writePosition required", (Object)e.toString());
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @Override
    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void enableCloseableTracing() {
        AbstractCloseable.enableCloseableTracing();
    }

    @After
    public void assertCloseablesClosed() {
        AbstractCloseable.assertCloseablesClosed();
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }
}

