/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public final class MessageHistoryTest
extends ChronicleQueueTestBase {
    @Rule
    public final TestName testName = new TestName();
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private File inputQueueDir;
    private File middleQueueDir;
    private File outputQueueDir;

    @Before
    public void setUp() {
        this.inputQueueDir = this.getTmpDir();
        this.middleQueueDir = this.getTmpDir();
        this.outputQueueDir = this.getTmpDir();
        VanillaMessageHistory messageHistory = new VanillaMessageHistory();
        messageHistory.addSourceDetails(true);
        MessageHistory.set((MessageHistory)messageHistory);
    }

    @Test
    public void shouldAccessMessageHistory() {
        try (ChronicleQueue inputQueue = this.createQueue(this.inputQueueDir, 1);
             ChronicleQueue outputQueue = this.createQueue(this.outputQueueDir, 2);){
            this.generateTestData(inputQueue, outputQueue);
            ExcerptTailer tailer = outputQueue.createTailer();
            ValidatingSecond validatingSecond = new ValidatingSecond();
            MethodReader validator = tailer.methodReader(new Object[]{validatingSecond});
            Assert.assertTrue((boolean)validator.readOne());
            Assert.assertTrue((boolean)validatingSecond.messageHistoryPresent());
        }
    }

    @Test
    public void shouldAccessMessageHistoryWhenTailerIsMovedToEnd() {
        try (ChronicleQueue inputQueue = this.createQueue(this.inputQueueDir, 1);
             ChronicleQueue outputQueue = this.createQueue(this.outputQueueDir, 2);){
            this.generateTestData(inputQueue, outputQueue);
            ExcerptTailer tailer = outputQueue.createTailer();
            tailer.direction(TailerDirection.BACKWARD).toEnd();
            ValidatingSecond validatingSecond = new ValidatingSecond();
            MethodReader validator = tailer.methodReader(new Object[]{validatingSecond});
            Assert.assertTrue((boolean)validator.readOne());
            Assert.assertTrue((boolean)validatingSecond.messageHistoryPresent());
        }
    }

    @Test
    public void chainedMessageHistory() {
        try (ChronicleQueue inputQueue = this.createQueue(this.inputQueueDir, 1);
             ChronicleQueue middleQueue = this.createQueue(this.middleQueueDir, 2);
             ChronicleQueue outputQueue = this.createQueue(this.middleQueueDir, 3);){
            this.generateTestData(inputQueue, middleQueue);
            MethodReader reader = middleQueue.createTailer().methodReader(new Object[]{outputQueue.methodWriter(First.class, new Class[0])});
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)reader.readOne());
            }
            MethodReader reader2 = outputQueue.createTailer().methodReader(new Object[]{this::say3});
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)reader2.readOne());
            }
        }
    }

    private void say3(String text) {
        MessageHistory messageHistory = MessageHistory.get();
        Assert.assertNotNull((Object)messageHistory);
        Assert.assertEquals((long)2L, (long)messageHistory.sources());
    }

    private void generateTestData(ChronicleQueue inputQueue, ChronicleQueue outputQueue) {
        First first = (First)inputQueue.acquireAppender().methodWriterBuilder(First.class).get();
        first.say("one");
        first.say("two");
        first.say("three");
        LoggingFirst loggingFirst = new LoggingFirst((Second)outputQueue.acquireAppender().methodWriterBuilder(Second.class).build());
        MethodReader reader = inputQueue.createTailer().methodReaderBuilder().build(new Object[]{loggingFirst});
        Assert.assertTrue((boolean)reader.readOne());
        Assert.assertTrue((boolean)reader.readOne());
        this.clock.addAndGet(TimeUnit.DAYS.toMillis(2L));
        Assert.assertTrue((boolean)reader.readOne());
        Assert.assertFalse((boolean)reader.readOne());
    }

    private ChronicleQueue createQueue(File queueDir, int sourceId) {
        return ChronicleQueue.singleBuilder((File)queueDir).sourceId(sourceId).timeProvider(this.clock::get).testBlockSize().build();
    }

    private static class ValidatingSecond
    implements Second {
        private boolean messageHistoryPresent = false;

        private ValidatingSecond() {
        }

        @Override
        public void count(int value) {
            MessageHistory messageHistory = MessageHistory.get();
            Assert.assertNotNull((Object)messageHistory);
            Assert.assertEquals((long)2L, (long)messageHistory.sources());
            this.messageHistoryPresent = true;
        }

        boolean messageHistoryPresent() {
            return this.messageHistoryPresent;
        }
    }

    private static final class LoggingFirst
    implements First {
        private final Second second;

        private LoggingFirst(Second second) {
            this.second = second;
        }

        @Override
        public void say(String word) {
            this.second.count(word.length());
        }
    }

    @FunctionalInterface
    static interface Second {
        public void count(int var1);
    }

    @FunctionalInterface
    static interface First {
        public void say(String var1);
    }
}

