/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDeleteQueueFile
extends ChronicleQueueTestBase {
    private Path tempQueueDir = this.getTmpDir().toPath();

    @Test
    public void testQueueFileDeletionWhileInUse() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        SetTimeProvider timeProvider = new SetTimeProvider();
        String queueName = "unitTestQueue";
        QueueStoreFileListener listener = new QueueStoreFileListener(queueName);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)(this.tempQueueDir + "/" + queueName)).timeProvider((TimeProvider)timeProvider).storeFileListener((StoreFileListener)listener).build();){
            int i;
            ExcerptAppender appender = queue.acquireAppender();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            for (int i2 = 0; i2 < 10; ++i2) {
                appender.writeText((CharSequence)"test");
            }
            long firstIndex = queue.firstIndex();
            long indexAfter10Records = appender.lastIndexAppended();
            timeProvider.advanceMillis(86400000L);
            appender.writeText((CharSequence)"test2");
            long firstIndexOfSecondCycle = appender.lastIndexAppended();
            for (int i3 = 0; i3 < 4; ++i3) {
                appender.writeText((CharSequence)"test2");
            }
            Map<String, List<String>> queueToRollFilesOnAcquireMap = listener.getQueueToRollFilesOnAcquireMap();
            Map<String, List<String>> queueToRollFilesOnReleaseMap = listener.getQueueToRollFilesOnReleaseMap();
            Assert.assertEquals((long)1L, (long)queueToRollFilesOnAcquireMap.size());
            List<String> files = queueToRollFilesOnAcquireMap.get(queueName);
            Assert.assertEquals((long)1L, (long)files.size());
            String secondFile = files.get(0);
            files = queueToRollFilesOnReleaseMap.get(queueName);
            Assert.assertEquals((long)1L, (long)files.size());
            String firstFile = files.get(0);
            Assert.assertNotEquals((Object)firstFile, (Object)secondFile);
            long indexAfter5Records = appender.lastIndexAppended();
            ExcerptTailer excerptTailer = queue.createTailer();
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)"test", (Object)excerptTailer.readText());
            }
            Assert.assertEquals((long)firstIndex, (long)(excerptTailer.index() - 10L));
            for (i = 0; i < 5; ++i) {
                Assert.assertEquals((Object)"test2", (Object)excerptTailer.readText());
            }
            Assert.assertEquals((long)indexAfter5Records, (long)(excerptTailer.index() - 1L));
            Files.delete(Paths.get(firstFile, new String[0]));
            queue.refreshDirectoryListing();
            Assert.assertEquals((long)queue.firstIndex(), (long)firstIndexOfSecondCycle);
            ExcerptTailer excerptTailer2 = queue.createTailer();
            Assert.assertEquals((long)(indexAfter5Records - 5L), (long)(excerptTailer2.index() - 1L));
            for (int i4 = 0; i4 < 5; ++i4) {
                Assert.assertEquals((Object)"test2", (Object)excerptTailer2.readText());
            }
        }
    }

    final class QueueStoreFileListener
    implements StoreFileListener {
        private String queueName;
        private Map<String, List<String>> queueToRollFilesOnReleaseMap = new HashMap<String, List<String>>();
        private Map<String, List<String>> queueToRollFilesOnAcquireMap = new HashMap<String, List<String>>();

        public QueueStoreFileListener(String queueName) {
            this.queueName = queueName;
        }

        public void onReleased(int cycle, File file) {
            String fileAbsPath;
            List<String> files = this.queueToRollFilesOnReleaseMap.get(this.queueName);
            if (files == null) {
                files = new ArrayList<String>();
            }
            if (!files.contains(fileAbsPath = file.getAbsolutePath())) {
                files.add(fileAbsPath);
            }
            this.queueToRollFilesOnReleaseMap.put(this.queueName, files);
            List<String> acqfiles = this.queueToRollFilesOnAcquireMap.get(this.queueName);
            acqfiles.remove(file.getAbsolutePath());
            this.queueToRollFilesOnAcquireMap.put(this.queueName, acqfiles);
        }

        public void onAcquired(int cycle, File file) {
            String fileAbsPath;
            List<String> files = this.queueToRollFilesOnAcquireMap.get(this.queueName);
            if (files == null) {
                files = new ArrayList<String>();
            }
            if (!files.contains(fileAbsPath = file.getAbsolutePath())) {
                files.add(fileAbsPath);
            }
            this.queueToRollFilesOnAcquireMap.put(this.queueName, files);
        }

        public Map<String, List<String>> getQueueToRollFilesOnAcquireMap() {
            return this.queueToRollFilesOnAcquireMap;
        }

        public Map<String, List<String>> getQueueToRollFilesOnReleaseMap() {
            return this.queueToRollFilesOnReleaseMap;
        }
    }
}

