/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.service;

import java.io.File;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.service.HelloReplier;
import net.openhft.chronicle.queue.service.HelloWorld;
import net.openhft.chronicle.queue.service.HelloWorldImpl;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import net.openhft.chronicle.queue.service.ServiceWrapperBuilder;
import org.easymock.EasyMock;
import org.junit.Ignore;
import org.junit.Test;

public class HelloWorldTest
extends QueueTestCommon {
    @Test
    public void testViaMock() {
        HelloReplier replier = (HelloReplier)EasyMock.createMock(HelloReplier.class);
        replier.reply("Hello April");
        replier.reply("Hello June");
        EasyMock.replay((Object[])new Object[]{replier});
        HelloWorldImpl helloWorld = new HelloWorldImpl(replier);
        helloWorld.hello("April");
        helloWorld.hello("June");
        EasyMock.verify((Object[])new Object[]{replier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="TODO FIX")
    public void testWithAsQueueService() {
        String input = OS.TARGET + "/input-" + System.nanoTime();
        String output = OS.TARGET + "/output-" + System.nanoTime();
        HelloReplier replier = (HelloReplier)EasyMock.createMock(HelloReplier.class);
        replier.reply("Hello April");
        replier.reply("Hello June");
        EasyMock.replay((Object[])new Object[]{replier});
        ServiceWrapperBuilder builder = ServiceWrapperBuilder.serviceBuilder((String)input, (String)output, HelloReplier.class, HelloWorldImpl::new).inputSourceId(1).outputSourceId(2);
        try (CloseableHelloWorld helloWorld = (CloseableHelloWorld)builder.inputWriter(CloseableHelloWorld.class);
             MethodReader replyReader = builder.outputReader(new Object[]{replier});
             ServiceWrapper helloWorldService = builder.get();){
            helloWorld.hello("April");
            helloWorld.hello("June");
            for (int i = 0; i < 2; ++i) {
                while (!replyReader.readOne()) {
                    Thread.yield();
                }
            }
            EasyMock.verify((Object[])new Object[]{replier});
        }
        finally {
            builder.closeQueues();
            try {
                IOTools.deleteDirWithFiles((File)new File(input), (int)2);
                IOTools.deleteDirWithFiles((File)new File(output), (int)2);
            }
            catch (IORuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    static interface CloseableHelloWorld
    extends HelloWorld,
    Closeable {
    }
}

