/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.micros;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.micros.MarketDataListener;
import net.openhft.chronicle.queue.micros.TopOfBookPrice;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.GenerateMethodWriter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SharedDocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WriteMarshallable;

public final class MarketDataListenerBinary_lightMethodWriter
implements MarketDataListener,
SharedDocumentContext {
    private final transient Closeable closeable;
    private final transient MethodWriterListener methodWriterListener;
    private final transient MarshallableOut out;
    private transient ThreadLocal<DocumentContextHolder> documentContextTL = ThreadLocal.withInitial(DocumentContextHolder::new);

    public MarketDataListenerBinary_lightMethodWriter(MarshallableOut out, Closeable closeable, MethodWriterListener methodWriterListener) {
        this.methodWriterListener = methodWriterListener;
        this.out = out;
        this.closeable = closeable;
    }

    public <T extends SharedDocumentContext> T documentContext(ThreadLocal<DocumentContextHolder> documentContextTL) {
        this.documentContextTL = documentContextTL;
        return (T)this;
    }

    @Override
    public void onTopOfBookPrice(TopOfBookPrice price) {
        DocumentContext dc = GenerateMethodWriter.acquireDocumentContext((boolean)false, this.documentContextTL, (MarshallableOut)this.out);
        if (this.out.recordHistory()) {
            dc.wire().writeEventName((CharSequence)"history").marshallable((WriteMarshallable)MessageHistory.get());
        }
        if (dc.wire().bytes().retainsComments()) {
            dc.wire().bytes().comment((CharSequence)"onTopOfBookPrice");
        }
        ValueOut valueOut = dc.wire().writeEventName((CharSequence)"onTopOfBookPrice");
        if (dc.wire().bytes().retainsComments()) {
            GenerateMethodWriter.addComment((Bytes)dc.wire().bytes(), (Object)((Object)price));
        }
        if (((Object)((Object)price)).getClass() == TopOfBookPrice.class) {
            valueOut.marshallable((WriteMarshallable)price);
        } else {
            valueOut.object((Object)price);
        }
        dc.close();
    }
}

