/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.batch.BatchAppenderNative;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;

public class BatchAppenderNativeTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNative() {
        if (!OS.isMacOSX()) {
            return;
        }
        Bytes bytes = Bytes.elasticByteBuffer();
        try {
            BatchAppenderNative batchAppenderNative = new BatchAppenderNative();
            long result = batchAppenderNative.writeMessages(bytes.addressForWrite(0L), bytes.realCapacity(), 1);
            int len = (int)result;
            int count = (int)(result >> 32);
            bytes.readLimit((long)len);
            Assert.assertEquals((long)16L, (long)len);
            Assert.assertEquals((long)1L, (long)count);
            Wire w = (Wire)WireType.BINARY.apply((Object)bytes);
            for (int i = 0; i < count; ++i) {
                try (DocumentContext dc = w.readingDocument();){
                    Assert.assertEquals((Object)"hello world", (Object)dc.wire().getValueIn().text());
                    continue;
                }
            }
        }
        finally {
            bytes.releaseLast();
        }
    }
}

