/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class JavaSouceCodeFormatter
implements Appendable,
CharSequence {
    private static final int INDENT_SPACES = 4;
    private final AtomicInteger indent;
    private final StringBuilder response = new StringBuilder();
    private StringBuilder sb = new StringBuilder();

    public JavaSouceCodeFormatter(AtomicInteger indent) {
        this.indent = indent;
    }

    public JavaSouceCodeFormatter() {
        this.indent = new AtomicInteger(0);
    }

    public JavaSouceCodeFormatter(int i) {
        this.indent = new AtomicInteger(i);
    }

    @Override
    @NotNull
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public Appendable append(CharSequence csq) {
        return this.sb.append(this.replaceNewLine(csq, 0, csq.length() - 1));
    }

    private CharSequence replaceNewLine(CharSequence csq, int start, int end) {
        this.response.setLength(0);
        boolean lastChargeWasNewLine = true;
        int lastNewlineIndex = 0;
        for (int i = start; i <= end; ++i) {
            char c = csq.charAt(i);
            this.response.append(c);
            if (c == '\n') {
                lastNewlineIndex = this.response.length();
                lastChargeWasNewLine = true;
                this.padding(this.response, this.indent.get());
                continue;
            }
            if (c == '{') {
                this.indent.incrementAndGet();
                continue;
            }
            if (c == '}') {
                this.indent.decrementAndGet();
                if (lastNewlineIndex < 0) continue;
                this.response.setLength(lastNewlineIndex);
                this.padding(this.response, this.indent.get());
                this.response.append("}");
                continue;
            }
            if (lastChargeWasNewLine && c == ' ') {
                this.response.setLength(this.response.length() - 1);
                continue;
            }
            lastChargeWasNewLine = false;
        }
        return this.response;
    }

    public void setLength(int len) {
        this.sb.setLength(len);
    }

    private void padding(StringBuilder target, int indent) {
        for (int i = 0; i < indent * 4; ++i) {
            target.append(' ');
        }
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        return this.sb.append(this.replaceNewLine(csq, start, end), start, end);
    }

    @Override
    public Appendable append(char c) {
        return this.sb.append(c);
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }
}

