/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireDumper {
    @NotNull
    private final WireIn wireIn;
    @NotNull
    private final Bytes bytes;
    private long headerNumber = -1L;

    private WireDumper(@Nullable WireIn wireIn, @NotNull Bytes bytes) {
        if (wireIn == null) {
            wireIn = new BinaryWire(bytes);
        }
        this.wireIn = wireIn;
        this.bytes = bytes;
    }

    @NotNull
    public static WireDumper of(@NotNull WireIn wireIn) {
        return new WireDumper(wireIn, wireIn.bytes());
    }

    @NotNull
    public static WireDumper of(@NotNull Bytes bytes) {
        return WireDumper.of(bytes, false);
    }

    @NotNull
    public static WireDumper of(@NotNull Bytes bytes, boolean align) {
        BinaryWire wireIn = new BinaryWire(bytes);
        wireIn.usePadding(align);
        return new WireDumper(wireIn, bytes);
    }

    @NotNull
    public String asString() {
        return this.asString(false);
    }

    @NotNull
    public String asString(boolean abbrev) {
        return this.asString(this.bytes.readPosition(), this.bytes.readRemaining(), abbrev);
    }

    @NotNull
    public String asString(long position, long length) {
        return this.asString(position, length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String asString(long position, long length, boolean abbrev) {
        @NotNull StringBuilder sb = new StringBuilder();
        long limit0 = this.bytes.readLimit();
        long position0 = this.bytes.readPosition();
        Bytes<ByteBuffer> bytes2 = Bytes.elasticByteBuffer();
        try {
            this.bytes.readPosition(position);
            long limit2 = Math.min(limit0, position + length);
            this.bytes.readLimit(limit2);
            long missing = position + length - limit2;
            while (this.bytes.readRemaining() >= 4L && !this.dumpOne(sb, bytes2, abbrev)) {
            }
            if (missing > 0L && !abbrev) {
                sb.append(" # missing: ").append(missing);
            }
        }
        catch (Throwable t) {
            sb.append(" ").append(t);
        }
        finally {
            this.bytes.readLimit(limit0);
            this.bytes.readPosition(position0);
            bytes2.releaseLast();
        }
        return sb.toString();
    }

    @Deprecated
    public boolean dumpOne(@NotNull StringBuilder sb) {
        return this.dumpOne(sb, null, false);
    }

    public boolean dumpOne(@NotNull StringBuilder sb, @Nullable Bytes<ByteBuffer> buffer) {
        return this.dumpOne(sb, buffer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpOne(@NotNull StringBuilder sb, @Nullable Bytes<ByteBuffer> buffer, boolean abbrev) {
        int len;
        if (this.wireIn.usePadding()) {
            this.bytes.readSkip(-this.bytes.readPosition() & 3L);
        }
        long start = this.bytes.readPosition();
        int header = this.bytes.readInt();
        if (header == 0) {
            if (!abbrev) {
                sb.append("...\n");
                sb.append("# ").append(this.bytes.readRemaining()).append(" bytes remaining\n");
            }
            return true;
        }
        if (Wires.isReadyData(header)) {
            ++this.headerNumber;
        }
        if (start > 0L && !abbrev) {
            sb.append("# position: ").append(start).append(", header: ");
            sb.append(this.headerNumber);
            if (Wires.isEndOfFile(header)) {
                sb.append(" EOF");
            } else if (Wires.isNotComplete(header)) {
                sb.append(" or ").append(this.headerNumber + 1L);
            }
            sb.append("\n");
        }
        if ((long)(len = Wires.lengthOf(header)) > this.bytes.readRemaining()) {
            sb.append("#  has a 4 byte size prefix, ").append(len).append(" > ").append(this.bytes.readRemaining()).append(" len is ").append(len);
            return true;
        }
        @NotNull String type = Wires.isData(header) ? (Wires.isReady(header) ? "!!data" : "!!not-ready-data!") : (Wires.isReady(header) ? "!!meta-data" : "!!not-ready-meta-data!");
        boolean binary = false;
        for (int i = 0; i < 4 && (long)i < this.bytes.readRemaining(); ++i) {
            byte b = this.bytes.readByte(this.bytes.readPosition() + (long)i);
            if (b >= 32 || b == 10) continue;
            binary = true;
            break;
        }
        if (!abbrev) {
            sb.append("--- ").append(type).append(binary ? " #binary" : "");
            if ((long)len > this.bytes.readRemaining()) {
                sb.append(" # len: ").append(len).append(", remaining: ").append(this.bytes.readRemaining());
            }
            sb.append("\n");
        }
        if (len == 0) {
            if (!abbrev) {
                sb.append("...\n");
                sb.append("# ").append(this.bytes.readRemaining()).append(" bytes remaining\n");
            }
            return true;
        }
        StreamingCommon textBytes = this.bytes;
        if (binary) {
            long readPosition = this.bytes.readPosition();
            long readLimit = this.bytes.readLimit();
            int sblen = sb.length();
            try {
                byte firstByte = this.bytes.readByte(this.bytes.readPosition());
                if (firstByte >= 0) {
                    this.dumpAsHexadecimal(sb, len, readPosition, sblen);
                    boolean bl = false;
                    return bl;
                }
                StreamingCommon bytes2 = buffer == null ? Bytes.elasticByteBuffer() : buffer.clear();
                @NotNull TextWire textWire = new TextWire((Bytes)bytes2);
                this.bytes.readLimit(readPosition + (long)len);
                this.wireIn.copyTo(textWire);
                textBytes = bytes2;
            }
            catch (Exception e) {
                this.dumpAsHexadecimal(sb, len, readPosition, sblen);
                boolean bl = false;
                return bl;
            }
            finally {
                this.bytes.readLimit(readLimit);
            }
            len = (int)textBytes.readRemaining();
        }
        try {
            for (int i = 0; i < len; ++i) {
                int ch = textBytes.readUnsignedByte();
                sb.append((char)ch);
            }
        }
        catch (Exception e) {
            sb.append(" ").append(e);
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        return false;
    }

    public void dumpAsHexadecimal(@NotNull StringBuilder sb, int len, long readPosition, int sblen) {
        this.bytes.readPositionRemaining(readPosition, len);
        sb.setLength(sblen);
        sb.append(this.bytes.toHexString(readPosition, Integer.MAX_VALUE));
        this.bytes.readPosition(readPosition + (long)len);
    }
}

