/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;

public class TextWriteDocumentContext
implements WriteDocumentContext {
    protected Wire wire;
    private boolean metaData;

    public TextWriteDocumentContext(Wire wire) {
        this.wire = wire;
    }

    @Override
    public void start(boolean metaData) {
        this.metaData = metaData;
        if (metaData) {
            this.wire().writeComment("meta-data");
        }
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void metaData(boolean metaData) {
        if (metaData != this.metaData) {
            throw new UnsupportedOperationException("cannot change metaData status");
        }
    }

    @Override
    public void close() {
        @NotNull Bytes<?> bytes = this.wire().bytes();
        long l = bytes.writePosition();
        if (l < 1L || bytes.peekUnsignedByte(l - 1L) >= 32) {
            bytes.append('\n');
        }
        if (TextMethodWriterInvocationHandler.ENABLE_EOD) {
            bytes.append("---\n");
        }
        this.wire().getValueOut().resetBetweenDocuments();
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    @Override
    public long index() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return true;
    }
}

