/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.TimeProvider;

public enum SystemTimeProvider implements TimeProvider
{
    INSTANCE;

    public static TimeProvider CLOCK;
    long delta = 0L;

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return this.currentTimeNanos() / 1000L;
    }

    @Override
    public long currentTimeNanos() {
        long nowMS;
        long n0 = System.nanoTime();
        long nowNS = n0;
        long estimate = nowNS + this.delta;
        if (estimate < (nowMS = this.currentTimeMillis() * 1000000L)) {
            this.delta = nowMS - nowNS;
            return nowMS;
        }
        if (estimate > nowMS + 1000000L) {
            this.delta = (nowMS += 1000000L) - nowNS;
            return nowMS;
        }
        return estimate;
    }

    static {
        CLOCK = INSTANCE;
        for (int i = 0; i < 1000; ++i) {
            INSTANCE.currentTimeMicros();
        }
    }
}

