/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;

public class TSQueueLock
extends AbstractTSQueueLock
implements QueueLock {
    private static final String LOCK_KEY = "chronicle.queue.lock";
    private static final int PID = Jvm.getProcessId();
    private final long timeout;

    public TSQueueLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        int count = 0;
        long lockValueFromTid = this.getLockValueFromTid(tid);
        long value = this.lock.getVolatileValue();
        try {
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, lockValueFromTid)) {
                if (count++ > 1000 && Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
        }
        catch (TimeoutException e) {
            this.warnLock("Overriding the lock. Couldn't acquire lock", value);
            this.forceUnlock(value);
            this.acquireLock();
        }
        finally {
            this.pauser.reset();
        }
    }

    private long getLockValueFromTid(long tid) {
        return tid << 32 | (long)PID;
    }

    @Override
    public void waitForLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        long value = this.lock.getVolatileValue();
        try {
            while (value != Long.MIN_VALUE) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
        }
        catch (TimeoutException e) {
            this.warnLock("Queue lock is still held", value);
            this.forceUnlock(value);
            this.waitForLock();
        }
        catch (NullPointerException ex) {
            if (!this.tableStore.isClosed()) {
                throw ex;
            }
            throw new IllegalStateException("The table store is closed!", ex);
        }
        finally {
            this.pauser.reset();
        }
    }

    private void warnLock(String msg, long value) {
        String pid = (int)value == PID ? "me" : Integer.toString((int)value);
        Jvm.warn().on(this.getClass(), "" + msg + " after " + this.timeout + "ms for the lock file:" + this.path + ". Lock is held by PID: " + pid + ", TID: " + (int)(value >>> 32) + ". Unlocking forcibly");
    }

    @Override
    public void unlock() {
        if (this.isClosed()) {
            try {
                this.throwExceptionIfClosed();
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), new IllegalStateException("Cannot unlock as already closed", e));
            }
            return;
        }
        long tid = Thread.currentThread().getId();
        if (!this.lock.compareAndSwapValue(this.getLockValueFromTid(tid), Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Queue lock was unlocked by someone else!");
        }
    }

    private boolean isLockHeldByCurrentThread(long tid) {
        return this.lock.getVolatileValue() == this.getLockValueFromTid(tid);
    }
}

