/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.CloseableTracer;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public abstract class AbstractCloseable
implements CloseableTracer,
ReferenceOwner {
    protected static final boolean CHECK_THREAD_SAFETY = Jvm.getBoolean("check.thread.safety", false);
    private static final long CLOSED_OFFSET;
    static volatile Set<CloseableTracer> CLOSEABLE_SET;
    private volatile transient int closed = 0;
    private volatile transient StackTrace createdHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass() + " - Created Here") : null;
    private volatile transient StackTrace closedHere;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private int referenceId;

    protected AbstractCloseable() {
        Set<CloseableTracer> set = CLOSEABLE_SET;
        if (set != null) {
            set.add(this);
        }
    }

    public static void enableCloseableTracing() {
        CLOSEABLE_SET = Collections.newSetFromMap(new WeakIdentityHashMap());
    }

    public static void disableCloseableTracing() {
        CLOSEABLE_SET = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCloseablesClosed() {
        Set<CloseableTracer> traceSet = CLOSEABLE_SET;
        if (traceSet == null) {
            Jvm.warn().on(AbstractCloseable.class, "closable tracing disabled");
            return;
        }
        BackgroundResourceReleaser.releasePendingResources();
        AssertionError openFiles = new AssertionError((Object)"Closeables still open");
        Set<CloseableTracer> set = traceSet;
        synchronized (set) {
            for (CloseableTracer key : traceSet) {
                Throwable t;
                if (key == null || key.isClosed()) continue;
                try {
                    if (key instanceof ReferenceCountedTracer) {
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    t = key.createdHere();
                }
                catch (IllegalStateException e) {
                    t = e;
                }
                IllegalStateException exception = new IllegalStateException("Not closed " + TracingReferenceCounted.asString(key), t);
                Thread.yield();
                if (key.isClosed()) {
                    System.out.println(exception.getMessage() + " is now closed...");
                    continue;
                }
                exception.printStackTrace();
                ((Throwable)((Object)openFiles)).addSuppressed(exception);
                key.close();
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    public static void unmonitor(Closeable closeable) {
        if (CLOSEABLE_SET != null) {
            CLOSEABLE_SET.remove(closeable);
        }
    }

    @Override
    public int referenceId() {
        if (this.referenceId == 0) {
            this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        }
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public final void close() {
        if (UnsafeMemory.UNSAFE.getAndSetInt(this, CLOSED_OFFSET, 1) != 0) {
            return;
        }
        StackTrace stackTrace = this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass() + " - Closed here") : null;
        if (BackgroundResourceReleaser.BG_RELEASER && this.performCloseInBackground()) {
            BackgroundResourceReleaser.release(this);
        } else {
            long start = System.nanoTime();
            try {
                this.performClose();
            }
            catch (Throwable e) {
                Jvm.debug().on(this.getClass(), "Exception thrown on performClose", e);
            }
            long time = System.nanoTime() - start;
            if (time >= 20000000L && !Thread.currentThread().getName().equals("background~resource~releaser")) {
                Jvm.warn().on(this.getClass(), "Took " + time / 1000000L + " ms to performClose");
            }
        }
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.closed != 0) {
            throw new ClosedIllegalStateException("Closed", this.closedHere);
        }
        if (CHECK_THREAD_SAFETY) {
            this.threadSafetyCheck(true);
        }
    }

    public void throwExceptionIfClosedInSetter() throws IllegalStateException {
        if (this.closed != 0) {
            throw new ClosedIllegalStateException("Closed", this.closedHere);
        }
        if (CHECK_THREAD_SAFETY) {
            this.threadSafetyCheck(false);
        }
    }

    protected void warnAndCloseIfNotClosed() {
        if (!this.isClosed()) {
            if (Jvm.isResourceTracing()) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing", new IllegalStateException(this.createdHere));
            }
            this.close();
        }
    }

    protected abstract void performClose();

    @Override
    public boolean isClosed() {
        return this.closed != 0;
    }

    protected boolean performCloseInBackground() {
        return false;
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        if (!CHECK_THREAD_SAFETY) {
            return true;
        }
        if (this.usedByThread == null && !isUsed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == null) {
            this.usedByThread = currentThread;
            if (Jvm.isResourceTracing()) {
                this.usedByThreadHere = new StackTrace("Used here");
            }
        } else if (this.usedByThread != currentThread) {
            if (this.usedByThread.isAlive()) {
                throw new IllegalStateException("Component which is not thread safes used by " + this.usedByThread + " and " + currentThread, this.usedByThreadHere);
            }
            this.usedByThread = currentThread;
        }
        return true;
    }

    public void resetUsedByThread() {
        this.usedByThread = Thread.currentThread();
        this.usedByThreadHere = new StackTrace("Used here");
    }

    public void clearUsedByThread() {
        this.usedByThread = null;
        this.usedByThreadHere = null;
    }

    public String toString() {
        return this.referenceName();
    }

    static {
        AbstractCloseable.enableCloseableTracing();
        CLOSED_OFFSET = UnsafeMemory.UNSAFE.objectFieldOffset(Jvm.getField(AbstractCloseable.class, "closed"));
    }
}

