/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class MoveToIndexTest
extends QueueTestCommon {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void shouldMoveToPreviousIndexAfterDocumentIsConsumed() throws IOException {
        File queuePath = this.tmpFolder.newFolder("cq");
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)queuePath).build();){
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 1; i < 10; ++i) {
                appender.writeText((CharSequence)("id" + i));
            }
            ExcerptTailer tailer = queue.createTailer();
            this.assertNext(tailer, "id1");
            long index = tailer.index();
            this.assertNext(tailer, "id2");
            tailer.moveToIndex(index);
            this.assertNext(tailer, "id2");
            tailer.moveToIndex(index);
            this.assertNext(tailer, "id2");
        }
    }

    @Test
    public void testRandomMove() throws IOException {
        HashMap<Long, String> messageByIndex = new HashMap<Long, String>();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpFolder.newFolder()).build();){
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                String message = "msg" + i;
                appender.writeDocument(w -> w.write((CharSequence)"message").object((Object)message));
                long appendIndex = appender.lastIndexAppended();
                messageByIndex.put(appendIndex, message);
            }
            Random random = new Random(1510298038000L);
            ArrayList indices = new ArrayList(messageByIndex.keySet());
            ExcerptTailer tailer = queue.createTailer();
            AtomicReference capturedMessage = new AtomicReference();
            for (int i = 0; i < 100; ++i) {
                long randomIndex = (Long)indices.get(random.nextInt(messageByIndex.keySet().size()));
                tailer.moveToIndex(randomIndex);
                tailer.readDocument(w -> capturedMessage.set((String)w.read("message").object()));
                Assert.assertEquals(messageByIndex.get(randomIndex), capturedMessage.get());
                tailer.readDocument(w -> w.read("message").object());
            }
        }
    }

    private void assertNext(ExcerptTailer tailer, String expected) {
        String next = tailer.readText();
        Assert.assertEquals((Object)expected, (Object)next);
    }
}

