/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;

public class CleaningThread
extends Thread {
    private static final Field THREAD_LOCALS = Jvm.getField(Thread.class, "threadLocals");
    private static final Field TABLE = Jvm.getField(THREAD_LOCALS.getType(), "table");
    private static final Field VALUE = Jvm.getField(TABLE.getType().getComponentType(), "value");

    public CleaningThread(Runnable target) {
        super(target);
    }

    public CleaningThread(Runnable target, String name) {
        super(target, name);
    }

    public static void performCleanup(Thread thread) {
        WeakReference[] table;
        try {
            Object o = THREAD_LOCALS.get(thread);
            if (o == null) {
                return;
            }
            table = (WeakReference[])TABLE.get(o);
        }
        catch (IllegalAccessException e) {
            Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            return;
        }
        if (table == null) {
            return;
        }
        for (WeakReference reference : table) {
            Object key;
            Object v0 = key = reference != null ? reference.get() : null;
            if (!(key instanceof CleaningThreadLocal)) continue;
            try {
                Object value = VALUE.get(reference);
                if (value == null) continue;
                CleaningThreadLocal ctl = key;
                ctl.cleanup(value);
            }
            catch (IllegalAccessException e) {
                Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            }
        }
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            CleaningThread.performCleanup(this);
        }
    }
}

