/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.pool.DynamicEnumClass;
import net.openhft.chronicle.core.pool.DynamicEnumPooled;
import net.openhft.chronicle.core.pool.StaticEnumClass;

public abstract class EnumCache<E> {
    private static final ClassLocal<EnumCache> ENUM_CACHE_CL = ClassLocal.withInitial(eClass -> DynamicEnumPooled.class.isAssignableFrom((Class<?>)eClass) ? new DynamicEnumClass(eClass) : new StaticEnumClass(eClass));
    protected final Class<E> eClass;

    protected EnumCache(Class<E> eClass) {
        this.eClass = eClass;
    }

    public static <E> EnumCache<E> of(Class<E> eClass) {
        return (EnumCache)ENUM_CACHE_CL.get(eClass);
    }

    public E get(String name) {
        return this.valueOf(name);
    }

    public abstract E valueOf(String var1);

    public abstract int initialSize();
}

