/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class CheckHalfWrittenMsgNotSeenByTailerTest {
    @Test
    public void checkTailerOnlyReadsTwoMessage() throws IOException, InterruptedException, ClassNotFoundException {
        File queueDirectory = DirectoryUtils.tempDir("halfWritten");
        String command = String.format("mvn compile exec:java -Dexec.classpathScope=test -Dexec.mainClass=%s -Dexec.args=\"%s\"", HalfWriteAMessage.class.getName(), queueDirectory.getAbsoluteFile());
        CheckHalfWrittenMsgNotSeenByTailerTest.runCommand(command);
        try (ChronicleQueue single = ChronicleQueue.single((String)queueDirectory.getPath());
             ExcerptTailer tailer = single.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 1", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 2", (Object)dc.wire().read("key2").text());
            }
            dc = tailer.readingDocument();
            var8_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 3", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 4", (Object)dc.wire().read("key2").text());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_12 = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    public void isPresent(DocumentContext dc) {
    }

    private static void runCommand(String command) throws IOException {
        String s;
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
            if (!"== FINISHED WRITING DATA ==".equals(s)) continue;
            return;
        }
        System.out.println("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            System.out.println(s);
        }
    }

    static {
        HalfWriteAMessage.class.getName();
    }

    public static class HalfWriteAMessage {
        public static void main(String[] args) throws InterruptedException {
            System.out.println("half writing a message to " + args[0]);
            try (ChronicleQueue single = ChronicleQueue.single((String)args[0]);
                 ExcerptAppender excerptAppender = single.acquireAppender();){
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"key1").text("hello world 1");
                    dc.wire().write((CharSequence)"key2").text("hello world 2");
                }
                dc = excerptAppender.writingDocument();
                var6_10 = null;
                try {
                    dc.wire().write((CharSequence)"key1").text("hello world 3");
                    dc.wire().write((CharSequence)"key2").text("hello world 4");
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var6_10 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var6_10.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                dc = excerptAppender.writingDocument();
                var6_10 = null;
                try {
                    dc.wire().write((CharSequence)"key1").text("hello world 5");
                    Thread.sleep(1L);
                    System.out.println("== FINISHED WRITING DATA ==");
                    System.exit(-1);
                    dc.wire().write((CharSequence)"key2").text("hello world 6");
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var6_10 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var6_10.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
        }
    }
}

