/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.EventHandlers;
import net.openhft.chronicle.threads.MediumEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaEventLoop
extends MediumEventLoop {
    public static final Set<HandlerPriority> ALLOWED_PRIORITIES = Collections.unmodifiableSet(EnumSet.of(HandlerPriority.HIGH, HandlerPriority.MEDIUM, HandlerPriority.TIMER, HandlerPriority.DAEMON));
    private static final Logger LOG = LoggerFactory.getLogger(VanillaEventLoop.class);
    private final List<EventHandler> timerHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final long timerIntervalMS;
    private final Set<HandlerPriority> priorities;

    public VanillaEventLoop(@Nullable EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, String binding, Set<HandlerPriority> priorities) {
        super(parent, name, pauser, daemon, binding);
        this.timerIntervalMS = timerIntervalMS;
        this.priorities = EnumSet.copyOf(priorities);
    }

    @Deprecated
    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding, int bindingCpu) {
        this(parent, name, pauser, timerIntervalMS, daemon, bindingCpu != -1 ? Integer.toString(bindingCpu) : (binding ? "any" : "none"), ALLOWED_PRIORITIES);
    }

    @Deprecated
    public VanillaEventLoop(@Nullable EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding) {
        this(parent, name, pauser, timerIntervalMS, daemon, binding ? "any" : "none", ALLOWED_PRIORITIES);
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        Closeable.closeQuietly(handlers);
    }

    private static void clearUsedByThread(@NotNull EventHandler handler) {
        if (handler instanceof AbstractCloseable) {
            ((AbstractCloseable)((Object)handler)).clearUsedByThread();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "VanillaEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", highHandler=" + this.highHandler + ", mediumHandlers=" + this.mediumHandlers + ", timerHandlers=" + this.timerHandlers + ", daemonHandlers=" + this.daemonHandlers + ", newHandler=" + this.newHandler + ", pauser=" + this.pauser + '}';
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        this.checkInterrupted();
        HandlerPriority priority = handler.priority();
        if (DEBUG_ADDING_HANDLERS && !this.priorities.contains((Object)priority)) {
            throw new IllegalStateException(this.name() + ": Unexpected priority " + (Object)((Object)priority) + " for " + handler + " allows " + this.priorities);
        }
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
            return;
        }
        do {
            this.pauser.unpause();
            this.throwExceptionIfClosed();
            this.checkInterrupted();
        } while (!this.newHandler.compareAndSet(null, handler));
    }

    @Override
    protected void loopStartedAllHandlers() {
        super.loopStartedAllHandlers();
        if (!this.timerHandlers.isEmpty()) {
            this.timerHandlers.forEach(EventHandler::loopStarted);
        }
        if (!this.daemonHandlers.isEmpty()) {
            this.daemonHandlers.forEach(EventHandler::loopStarted);
        }
    }

    @Override
    protected void loopFinishedAllHandlers() {
        super.loopFinishedAllHandlers();
        if (!this.timerHandlers.isEmpty()) {
            this.timerHandlers.forEach(Threads::loopFinishedQuietly);
        }
        if (!this.daemonHandlers.isEmpty()) {
            this.daemonHandlers.forEach(Threads::loopFinishedQuietly);
        }
    }

    @Override
    protected long timerIntervalMS() {
        return this.timerIntervalMS;
    }

    @Override
    protected void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.timerHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                VanillaEventLoop.removeHandler(handler, this.timerHandlers);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    @Override
    protected void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.daemonHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                VanillaEventLoop.removeHandler(handler, this.daemonHandlers);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    @Override
    protected void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1.alias()) {
            case HIGH: {
                if (this.highHandler == EventHandlers.NOOP || this.highHandler == handler) {
                    this.highHandler = handler;
                    break;
                }
                Jvm.warn().on(this.getClass(), "Only one high handler supported was " + this.highHandler + ", treating " + handler + " as MEDIUM");
            }
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                this.mediumHandlers.add(handler);
                this.mediumHandlers.sort(Comparator.comparing(EventHandler::priority).reversed());
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                break;
            }
            case TIMER: {
                if (this.timerHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                this.timerHandlers.add(handler);
                break;
            }
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent != null ? this.parent : this);
        if (this.thread != null) {
            handler.loopStarted();
        }
    }

    @Override
    public int handlerCount() {
        return this.nonDaemonHandlerCount() + this.daemonHandlers.size() + this.timerHandlers.size();
    }

    @Override
    protected void performClose() {
        try {
            super.performClose();
        }
        finally {
            this.daemonHandlers.clear();
            this.timerHandlers.clear();
        }
    }

    @Override
    protected void closeAllHandlers() {
        VanillaEventLoop.closeAll(this.daemonHandlers);
        VanillaEventLoop.closeAll(this.timerHandlers);
        super.closeAllHandlers();
    }

    @Override
    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(Collections.singletonList(this.highHandler), this.mediumHandlers, this.daemonHandlers, this.timerHandlers).flatMap(Collection::stream).filter(e -> e != EventHandlers.NOOP).filter(e -> e instanceof Closeable).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        LOG.info("Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> LOG.info("\t" + h));
    }

    @Override
    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

