/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.ChronicleReaderPlugin;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.queue.reader.Reader;
import net.openhft.chronicle.queue.util.ToolsUtil;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public final class InternalChronicleReader
implements Reader {
    private static final long UNSET_VALUE = Long.MIN_VALUE;
    private final List<Pattern> inclusionRegex = new ArrayList<Pattern>();
    private final List<Pattern> exclusionRegex = new ArrayList<Pattern>();
    private final Pauser pauser = Pauser.millis(1, 100);
    private Path basePath;
    private long startIndex = Long.MIN_VALUE;
    private boolean tailInputSource = false;
    private long maxHistoryRecords = Long.MIN_VALUE;
    private boolean readOnly = true;
    private ChronicleReaderPlugin customPlugin;
    private Consumer<? super String> messageSink;
    private Function<ExcerptTailer, DocumentContext> pollMethod = ExcerptTailer::readingDocument;
    private WireType wireType = WireType.TEXT;
    private Supplier<QueueEntryHandler> entryHandlerFactory = () -> QueueEntryHandler.messageToText(this.wireType);
    private boolean displayIndex = true;
    private Class<?> methodReaderInterface;
    private volatile boolean running = true;
    private ThreadLocal<ExcerptTailer> tlTailer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean retryLastOperation;
        long highestReachedIndex = 0L;
        boolean isFirstIteration = true;
        do {
            try (ChronicleQueue queue = this.createQueue();
                 QueueEntryHandler messageConverter = this.entryHandlerFactory.get();){
                boolean queueHasBeenModified;
                ExcerptTailer tailer = queue.createTailer();
                this.tlTailer = ThreadLocal.withInitial(queue::createTailer);
                do {
                    long lastObservedTailIndex;
                    if (highestReachedIndex != 0L) {
                        tailer.moveToIndex(highestReachedIndex);
                    }
                    Bytes<ByteBuffer> textConversionTarget = Bytes.elasticByteBuffer();
                    try {
                        BooleanSupplier readOne;
                        this.moveToSpecifiedPosition(queue, tailer, isFirstIteration);
                        lastObservedTailIndex = tailer.index();
                        Consumer<String> messageConsumer = text -> this.applyFiltersAndLog((String)text, tailer.index());
                        if (this.methodReaderInterface == null) {
                            readOne = () -> this.readOne(messageConverter, tailer, messageConsumer);
                        } else {
                            Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer(256);
                            Object writer = ((Wire)WireType.TEXT.apply(bytes)).methodWriter(this.methodReaderInterface, new Class[0]);
                            MethodReader methodReader = tailer.methodReader(writer);
                            readOne = () -> {
                                boolean found = methodReader.readOne();
                                if (found) {
                                    messageConsumer.accept(bytes.toString());
                                }
                                bytes.clear();
                                return found;
                            };
                        }
                        while (!Thread.currentThread().isInterrupted()) {
                            boolean found = readOne.getAsBoolean();
                            if (!found) {
                                if (this.tailInputSource) {
                                    this.pauser.pause();
                                }
                                break;
                            }
                            this.pauser.reset();
                        }
                    }
                    finally {
                        textConversionTarget.releaseLast();
                        highestReachedIndex = tailer.index();
                        isFirstIteration = false;
                    }
                    queueHasBeenModified = this.queueHasBeenModifiedSinceLastCheck(lastObservedTailIndex, queue);
                    retryLastOperation = false;
                    if (this.running) continue;
                    return;
                } while (this.tailInputSource || queueHasBeenModified);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof DateTimeParseException) {
                    retryLastOperation = true;
                    continue;
                }
                throw e;
            }
        } while (retryLastOperation);
    }

    @Override
    public boolean readOne(@NotNull QueueEntryHandler messageConverter, @NotNull ExcerptTailer tailer, @NotNull Consumer<String> messageConsumer) {
        ObjectUtils.requireNonNull(messageConsumer);
        ObjectUtils.requireNonNull(tailer);
        ObjectUtils.requireNonNull(messageConsumer);
        try (DocumentContext dc = this.pollMethod.apply(tailer);){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (this.customPlugin == null) {
                messageConverter.accept(dc.wire(), messageConsumer);
            } else {
                this.customPlugin.onReadDocument(dc, messageConsumer);
            }
        }
        return true;
    }

    InternalChronicleReader withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public InternalChronicleReader withMessageSink(@NotNull Consumer<? super String> messageSink) {
        this.messageSink = ObjectUtils.requireNonNull(messageSink);
        return this;
    }

    public Consumer<? super String> messageSink() {
        return this.messageSink;
    }

    @Override
    public InternalChronicleReader withBasePath(@NotNull Path path) {
        this.basePath = ObjectUtils.requireNonNull(path);
        return this;
    }

    @Override
    public InternalChronicleReader withInclusionRegex(@NotNull String regex) {
        this.inclusionRegex.add(Pattern.compile(ObjectUtils.requireNonNull(regex)));
        return this;
    }

    @Override
    public InternalChronicleReader withExclusionRegex(@NotNull String regex) {
        this.exclusionRegex.add(Pattern.compile(ObjectUtils.requireNonNull(regex)));
        return this;
    }

    @Override
    public InternalChronicleReader withCustomPlugin(@NotNull ChronicleReaderPlugin customPlugin) {
        this.customPlugin = ObjectUtils.requireNonNull(customPlugin);
        return this;
    }

    @Override
    public InternalChronicleReader withStartIndex(long index) {
        this.startIndex = index;
        return this;
    }

    @Override
    public InternalChronicleReader tail() {
        this.tailInputSource = true;
        return this;
    }

    @Override
    public InternalChronicleReader historyRecords(long maxHistoryRecords) {
        this.maxHistoryRecords = maxHistoryRecords;
        return this;
    }

    @Override
    public InternalChronicleReader asMethodReader(String methodReaderInterface) {
        if (methodReaderInterface == null) {
            this.entryHandlerFactory = () -> QueueEntryHandler.dummy(this.wireType);
        } else {
            try {
                this.methodReaderInterface = Class.forName(methodReaderInterface);
            }
            catch (ClassNotFoundException e) {
                throw Jvm.rethrow(e);
            }
        }
        return this;
    }

    @Override
    public InternalChronicleReader withWireType(@NotNull WireType wireType) {
        this.wireType = ObjectUtils.requireNonNull(wireType);
        return this;
    }

    @Override
    public InternalChronicleReader suppressDisplayIndex() {
        this.displayIndex = false;
        return this;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    InternalChronicleReader withDocumentPollMethod(Function<ExcerptTailer, DocumentContext> pollMethod) {
        this.pollMethod = ObjectUtils.requireNonNull(pollMethod);
        return this;
    }

    private boolean queueHasBeenModifiedSinceLastCheck(long lastObservedTailIndex, ChronicleQueue queue) {
        long currentTailIndex = this.indexOfEnd(queue);
        return currentTailIndex > lastObservedTailIndex;
    }

    private void moveToSpecifiedPosition(ChronicleQueue ic, ExcerptTailer tailer, boolean isFirstIteration) {
        if (InternalChronicleReader.isSet(this.startIndex) && isFirstIteration) {
            if (this.startIndex < ic.firstIndex()) {
                throw new IllegalArgumentException(String.format("startIndex %d is less than first index %d", this.startIndex, ic.firstIndex()));
            }
            this.messageSink.accept("Waiting for startIndex " + this.startIndex);
            while (!tailer.moveToIndex(this.startIndex)) {
                Jvm.pause(100L);
            }
        }
        if (InternalChronicleReader.isSet(this.maxHistoryRecords) && isFirstIteration) {
            tailer.toEnd();
            tailer.moveToIndex(Math.max(ic.firstIndex(), tailer.index() - this.maxHistoryRecords));
        } else if (this.tailInputSource && isFirstIteration) {
            tailer.toEnd();
        }
    }

    private static boolean checkForMatches(List<Pattern> patterns, String text, boolean shouldBePresent) {
        for (Pattern pattern : patterns) {
            if (!shouldBePresent != pattern.matcher(text).find()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSet(long configValue) {
        return configValue != Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long indexOfEnd(ChronicleQueue queue) {
        ExcerptTailer excerptTailer = this.tlTailer.get();
        long index = excerptTailer.index();
        try {
            long l = excerptTailer.toEnd().index();
            return l;
        }
        finally {
            excerptTailer.moveToIndex(index);
        }
    }

    @NotNull
    private ChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path '%s' does not exist (absolute path '%s')", this.basePath, this.basePath.toAbsolutePath()));
        }
        return SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(this.readOnly).storeFileListener(StoreFileListener.NO_OP).build();
    }

    protected void applyFiltersAndLog(String text, long index) {
        if ((this.inclusionRegex.isEmpty() || InternalChronicleReader.checkForMatches(this.inclusionRegex, text, true)) && (this.exclusionRegex.isEmpty() || InternalChronicleReader.checkForMatches(this.exclusionRegex, text, false))) {
            if (this.displayIndex) {
                this.messageSink.accept("0x" + Long.toHexString(index) + ": ");
            }
            this.messageSink.accept(text);
        }
    }

    static {
        ToolsUtil.warnIfResourceTracing();
    }
}

