/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Test;

public class StoreAppenderTest {
    @Test(expected=IllegalStateException.class)
    public void testJumpingAMessageThrowsAIllegalStateException() {
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("q")).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider(() -> 0L).build();
             ExcerptAppender appender = q.acquireAppender();){
            appender.writeText((CharSequence)"hello");
            appender.writeText((CharSequence)"hello");
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeLong(1L);
            }
            long l = appender.lastIndexAppended();
            RollCycle rollCycle = q.rollCycle();
            long index = rollCycle.toIndex(rollCycle.toCycle(l) + 1, 1L);
            ((InternalAppender)appender).writeBytes(index, (BytesStore)Bytes.from((String)"text"));
        }
    }
}

