/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleCQFormat2Test
extends ChronicleQueueTestBase {
    private int appendMode;

    private static void assertHexEquals(long a, long b) {
        if (a != b) {
            Assert.assertEquals((String)(Long.toHexString(a) + " != " + Long.toHexString(b)), (long)a, (long)b);
        }
    }

    @Test
    public void testMyData() {
        @NotNull File dir = this.getTmpDir();
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{MyData.class});
        try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            @NotNull ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                @NotNull MyData name = new MyData("name", 12345L, 1.2, 111);
                name.writeMarshallable((WireOut)dc.wire());
                @NotNull MyData name2 = new MyData("name2", 12346L, 1.3, 112);
                name2.writeMarshallable((WireOut)dc.wire());
            }
            String dump = queue.dump();
            Assert.assertTrue((String)dump, (boolean)dump.contains("--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]"));
        }
    }

    @Test
    public void testWritingThreeMessages() throws FileNotFoundException {
        int m = 0;
        while (m <= 2) {
            this.appendMode = m++;
            @NotNull File dir = this.getTmpDir();
            dir.mkdir();
            try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(1).build();){
                long start = RollCycles.DEFAULT.toIndex(queue.cycle(), 0L);
                this.appendMessage((ChronicleQueue)queue, start, "Hello World");
                @NotNull String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Hello World\n...\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager);
                this.appendMessage((ChronicleQueue)queue, start + 1L, "Another Hello World");
                @NotNull String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    412,\n    1769526525953\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  392,\n  412,\n  0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Hello World\n--- !!data #binary\nmsg: Another Hello World\n...\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager2);
                this.appendMessage((ChronicleQueue)queue, start + 2L, "Bye for now");
                @NotNull String expectedEager3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    440,\n    1889785610242\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 3\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  392,\n  412,\n  440,\n  0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Hello World\n--- !!data #binary\nmsg: Another Hello World\n--- !!data #binary\nmsg: Bye for now\n...\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager3);
            }
        }
    }

    private File getFirstQueueFile(File file) {
        return file.listFiles((d, n) -> n.endsWith(".cq4"))[0];
    }

    public void checkFileContents(@NotNull File file, String expected) throws FileNotFoundException {
        @NotNull MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        bytes.readLimit(bytes.realCapacity());
        Assert.assertEquals((Object)expected, (Object)Wires.fromAlignedSizePrefixedBlobs((Bytes)bytes).replaceAll("(?m)^#.+$\\n", ""));
        bytes.releaseLast();
    }

    @Test
    public void testWritingTwentyMessagesTinyIndex() throws FileNotFoundException {
        for (int spacing : new int[]{1, 2, 4}) {
            @NotNull File dir = this.getTmpDir();
            dir.mkdir();
            try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(spacing).build();){
                long start = RollCycles.DEFAULT.toIndex(queue.cycle(), 0L);
                @NotNull ExcerptTailer tailer = queue.createTailer();
                Assert.assertFalse((boolean)tailer.moveToIndex(start));
                this.appendMessage((ChronicleQueue)queue, start, "Hello World");
                @NotNull String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Hello World\n...\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager.replace("indexSpacing: 1", "indexSpacing: " + spacing).replace("lastIndex: 1", "lastIndex: " + spacing));
                Assert.assertTrue((boolean)tailer.moveToIndex(start));
                for (int i = 1; i < 19; ++i) {
                    Assert.assertFalse((boolean)tailer.moveToIndex(start + (long)i));
                    this.appendMessage((ChronicleQueue)queue, start + (long)i, "Another Hello World " + (i + 1));
                    Assert.assertTrue((boolean)tailer.moveToIndex(start + (long)i));
                }
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 19L));
                this.appendMessage((ChronicleQueue)queue, start + 19L, "Bye for now");
                Assert.assertTrue((boolean)tailer.moveToIndex(start + 19L));
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 20L));
                @NotNull String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1176,\n    5050881540115\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 20\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  296,\n  668,\n  1016,\n  0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  392,\n  412,\n  444,\n  476,\n  508,\n  540,\n  572,\n  604\n]\n--- !!data #binary\nmsg: Hello World\n--- !!data #binary\nmsg: Another Hello World 2\n--- !!data #binary\nmsg: Another Hello World 3\n--- !!data #binary\nmsg: Another Hello World 4\n--- !!data #binary\nmsg: Another Hello World 5\n--- !!data #binary\nmsg: Another Hello World 6\n--- !!data #binary\nmsg: Another Hello World 7\n--- !!data #binary\nmsg: Another Hello World 8\n--- !!data #binary\nmsg: Another Hello World 9\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  636,\n  760,\n  792,\n  824,\n  856,\n  888,\n  920,\n  952\n]\n--- !!data #binary\nmsg: Another Hello World 10\n--- !!data #binary\nmsg: Another Hello World 11\n--- !!data #binary\nmsg: Another Hello World 12\n--- !!data #binary\nmsg: Another Hello World 13\n--- !!data #binary\nmsg: Another Hello World 14\n--- !!data #binary\nmsg: Another Hello World 15\n--- !!data #binary\nmsg: Another Hello World 16\n--- !!data #binary\nmsg: Another Hello World 17\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 4\n  984,\n  1112,\n  1144,\n  1176,\n  0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Another Hello World 18\n--- !!data #binary\nmsg: Another Hello World 19\n--- !!data #binary\nmsg: Bye for now\n...\n";
                @NotNull String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1080,\n    4638564679699\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 196,\n    lastIndex: 20\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 2\n  296,\n  924,\n  0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  392,\n  444,\n  508,\n  572,\n  636,\n  700,\n  764,\n  828\n]\n--- !!data #binary\nmsg: Hello World\n--- !!data #binary\nmsg: Another Hello World 2\n--- !!data #binary\nmsg: Another Hello World 3\n--- !!data #binary\nmsg: Another Hello World 4\n--- !!data #binary\nmsg: Another Hello World 5\n--- !!data #binary\nmsg: Another Hello World 6\n--- !!data #binary\nmsg: Another Hello World 7\n--- !!data #binary\nmsg: Another Hello World 8\n--- !!data #binary\nmsg: Another Hello World 9\n--- !!data #binary\nmsg: Another Hello World 10\n--- !!data #binary\nmsg: Another Hello World 11\n--- !!data #binary\nmsg: Another Hello World 12\n--- !!data #binary\nmsg: Another Hello World 13\n--- !!data #binary\nmsg: Another Hello World 14\n--- !!data #binary\nmsg: Another Hello World 15\n--- !!data #binary\nmsg: Another Hello World 16\n--- !!data #binary\nmsg: Another Hello World 17\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  892,\n  1048,\n  0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg: Another Hello World 18\n--- !!data #binary\nmsg: Another Hello World 19\n--- !!data #binary\nmsg: Bye for now\n...\n";
                @NotNull String expected3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    988,\n    4243427688467\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 20\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 5\n  392,\n  508,\n  636,\n  764,\n  892,\n  0, 0, 0\n]\n--- !!data #binary\nmsg: Hello World\n--- !!data #binary\nmsg: Another Hello World 2\n--- !!data #binary\nmsg: Another Hello World 3\n--- !!data #binary\nmsg: Another Hello World 4\n--- !!data #binary\nmsg: Another Hello World 5\n--- !!data #binary\nmsg: Another Hello World 6\n--- !!data #binary\nmsg: Another Hello World 7\n--- !!data #binary\nmsg: Another Hello World 8\n--- !!data #binary\nmsg: Another Hello World 9\n--- !!data #binary\nmsg: Another Hello World 10\n--- !!data #binary\nmsg: Another Hello World 11\n--- !!data #binary\nmsg: Another Hello World 12\n--- !!data #binary\nmsg: Another Hello World 13\n--- !!data #binary\nmsg: Another Hello World 14\n--- !!data #binary\nmsg: Another Hello World 15\n--- !!data #binary\nmsg: Another Hello World 16\n--- !!data #binary\nmsg: Another Hello World 17\n--- !!data #binary\nmsg: Another Hello World 18\n--- !!data #binary\nmsg: Another Hello World 19\n--- !!data #binary\nmsg: Bye for now\n...\n";
                @NotNull String expected = spacing == 1 ? expected1 : (spacing == 2 ? expected2 : expected3);
                this.checkFileContents(this.getFirstQueueFile(dir), expected);
            }
        }
    }

    @Before
    public void resetAppendMode() {
        this.appendMode = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void appendMessage(@NotNull ChronicleQueue queue, long expectedIndex, String msg) {
        appender = queue.acquireAppender();
        switch (this.appendMode) {
            case 1: {
                appender.writeDocument((WriteMarshallable)LambdaMetafactory.metafactory(null, null, null, (Lnet/openhft/chronicle/wire/WireOut;)V, lambda$appendMessage$1(java.lang.String net.openhft.chronicle.wire.WireOut ), (Lnet/openhft/chronicle/wire/WireOut;)V)((String)msg));
                break;
            }
            case 2: {
                bytes = Bytes.elasticByteBuffer();
                new BinaryWire(bytes).write((CharSequence)"msg").text(msg);
                appender.writeBytes(bytes);
                bytes.releaseLast();
                break;
            }
            default: {
                dc = appender.writingDocument();
                var8_8 = null;
                wire = dc.wire();
                wire.write((CharSequence)"msg").text(msg);
                if (dc == null) break;
                if (var8_8 == null) ** GOTO lbl28
                try {
                    dc.close();
                }
                catch (Throwable var9_10) {
                    var8_8.addSuppressed(var9_10);
                }
                break;
lbl28:
                // 1 sources

                dc.close();
                break;
                catch (Throwable var9_11) {
                    try {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    catch (Throwable var10_12) {
                        if (dc != null) {
                            if (var8_8 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var11_13) {
                                    var8_8.addSuppressed(var11_13);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        index = appender.lastIndexAppended();
        SingleCQFormat2Test.assertHexEquals(expectedIndex, index);
    }

    @Test
    public void writeMap() {
        @NotNull TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("abc", "def");
        map.put("hello", "world");
        map.put("number", 1L);
        map.put("double", 1.28);
        @NotNull File dir = this.getTmpDir();
        try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeMap(map);
            map.put("abc", "aye-bee-see");
            appender.writeMap(map);
            String expectedEager = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 1\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    452,\n    1941325217793\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  392,\n  452,\n  0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump().replaceAll("(?m)^#.+$\\n", ""));
            @NotNull ExcerptTailer tailer = queue.createTailer();
            Map map2 = tailer.readMap();
            Map map3 = tailer.readMap();
            Assert.assertEquals((Object)"{abc=def, double=1.28, hello=world, number=1}", (Object)map2.toString());
            Assert.assertEquals((Object)"{abc=aye-bee-see, double=1.28, hello=world, number=1}", (Object)map3.toString());
            Assert.assertNull((Object)tailer.readMap());
        }
    }

    @Test
    public void writeMarshallable() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Order.class});
        @NotNull File dir = this.getTmpDir();
        try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();){
            @NotNull ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((WriteMarshallable)new Order("Symbol", Side.Buy, 1.2345, 1000000.0));
            appender.writeDocument(w -> w.write((CharSequence)"newOrder").object((Object)new Order("Symbol2", Side.Sell, 2.999, 1.0E7)));
            String expectedEager = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 1\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    448,\n    1924145348609\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  392,\n  448,\n  0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump().replaceAll("(?m)^#.+$\\n", ""));
        }
    }

    @Test
    public void testWritingIndex() {
        @NotNull File dir = this.getTmpDir();
        try (@NotNull SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();){
            @NotNull ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"msg-1");
            String expectedEager = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 1\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nmsg-1\n...\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump().replaceAll("(?m)^#.+$\\n", ""));
        }
    }

    private static /* synthetic */ void lambda$appendMessage$1(String msg, WireOut w) {
        w.write((CharSequence)"msg").text(msg);
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }

    private static class MyData
    extends SelfDescribingMarshallable {
        final String name;
        final long num;
        final double d;
        final int counter;

        MyData(String name, long num, double d, int counter) {
            this.name = name;
            this.num = num;
            this.d = d;
            this.counter = counter;
        }
    }
}

