/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMessageHistory
extends SelfDescribingMarshallable
implements MessageHistory {
    public static final int MESSAGE_HISTORY_LENGTH = 128;
    private static final ThreadLocal<MessageHistory> THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        @NotNull VanillaMessageHistory veh = new VanillaMessageHistory();
        veh.addSourceDetails(true);
        return veh;
    });
    private int sources;
    private int timings;
    @NotNull
    private final int[] sourceIdArray = new int[128];
    @NotNull
    private final long[] sourceIndexArray = new long[128];
    @NotNull
    private final long[] timingsArray = new long[256];
    private boolean addSourceDetails = false;
    private long start;

    static MessageHistory getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    static void setThreadLocal(MessageHistory md) {
        THREAD_LOCAL.set(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int marshallableSize(@NotNull BytesIn bytes) {
        long start = bytes.readPosition();
        try {
            int sources = bytes.readUnsignedByte();
            int size = 1;
            size += 4 * sources;
            bytes.readSkip((size += 8 * sources) - 1);
            int timings = bytes.readUnsignedByte() - 1;
            ++size;
            size += timings * 8;
            int n = size += 8;
            return n;
        }
        finally {
            bytes.readPosition(start);
        }
    }

    public void addSourceDetails(boolean addSourceDetails) {
        this.addSourceDetails = addSourceDetails;
    }

    @Override
    public void reset() {
        this.timings = 0;
        this.sources = 0;
    }

    public boolean addSourceDetails() {
        return this.addSourceDetails;
    }

    @Override
    public void reset(int sourceId, long sourceIndex) {
        this.sources = 1;
        this.sourceIdArray[0] = sourceId;
        this.sourceIndexArray[0] = sourceIndex;
        this.timings = 1;
        this.timingsArray[0] = this.nanoTime();
    }

    @Override
    public int lastSourceId() {
        return this.sources <= 0 ? -1 : this.sourceIdArray[this.sources - 1];
    }

    @Override
    public long lastSourceIndex() {
        return this.sources <= 0 ? -1L : this.sourceIndexArray[this.sources - 1];
    }

    @Override
    public int timings() {
        return this.timings;
    }

    @Override
    public long timing(int n) {
        return this.timingsArray[n];
    }

    @Override
    public int sources() {
        return this.sources;
    }

    @Override
    public int sourceId(int n) {
        return this.sourceIdArray[n];
    }

    @Override
    public boolean sourceIdsEndsWith(int[] sourceIds) {
        int start = this.sources - sourceIds.length;
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < sourceIds.length; ++i) {
            if (this.sourceId(start + i) == sourceIds[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sourceIndex(int n) {
        return this.sourceIndexArray[n];
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.sources = 0;
        wire.read("sources").sequence(this, VanillaMessageHistory::acceptSourcesRead);
        this.timings = 0;
        wire.read("timings").sequence(this, VanillaMessageHistory::acceptTimingsRead);
        if (this.addSourceDetails) {
            @Nullable Object o = wire.parent();
            if (o instanceof SourceContext) {
                @Nullable SourceContext dc = (SourceContext)o;
                this.addSource(dc.sourceId(), dc.index());
            }
            this.addTiming(this.nanoTime());
        }
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write("sources").sequence(this, this::acceptSources);
        wire.write("timings").sequence(this, this::acceptTimings);
    }

    @Override
    public void readMarshallable(@NotNull BytesIn bytes) throws IORuntimeException {
        int i;
        this.sources = bytes.readUnsignedByte();
        for (i = 0; i < this.sources; ++i) {
            this.sourceIdArray[i] = bytes.readInt();
        }
        for (i = 0; i < this.sources; ++i) {
            this.sourceIndexArray[i] = bytes.readLong();
        }
        this.timings = bytes.readUnsignedByte();
        for (i = 0; i < this.timings; ++i) {
            this.timingsArray[i] = bytes.readLong();
        }
    }

    @Override
    public void writeMarshallable(@NotNull BytesOut b) {
        int i;
        BytesOut bytes = b;
        assert (this.start(bytes.writePosition()));
        ((BytesOut)bytes.comment("sources")).writeUnsignedByte(this.sources);
        for (i = 0; i < this.sources; ++i) {
            bytes.writeInt(this.sourceIdArray[i]);
        }
        for (i = 0; i < this.sources; ++i) {
            bytes.writeLong(this.sourceIndexArray[i]);
        }
        ((BytesOut)bytes.comment("timings")).writeUnsignedByte(this.timings + 1);
        for (i = 0; i < this.timings; ++i) {
            bytes.writeLong(this.timingsArray[i]);
        }
        bytes.writeLong(this.nanoTime());
        assert (this.checkMarshallableSize(this.start, (Bytes)bytes));
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    private static void acceptSourcesRead(VanillaMessageHistory t, ValueIn in) {
        while (in.hasNextSequenceItem()) {
            t.addSource(in.int32(), in.int64());
        }
    }

    private static void acceptTimingsRead(VanillaMessageHistory t, ValueIn in) {
        while (in.hasNextSequenceItem()) {
            t.addTiming(in.int64());
        }
    }

    private void acceptSources(VanillaMessageHistory t, ValueOut out) {
        Bytes<?> b = out.wireOut().bytes();
        for (int i = 0; i < t.sources; ++i) {
            b.comment("source id & index");
            out.uint32(t.sourceIdArray[i]);
            out.int64_0x(t.sourceIndexArray[i]);
        }
    }

    private void acceptTimings(VanillaMessageHistory t, ValueOut out) {
        Bytes<?> b = out.wireOut().bytes();
        for (int i = 0; i < t.timings; ++i) {
            b.comment("timing in nanos");
            out.int64(t.timingsArray[i]);
        }
        out.int64(this.nanoTime());
    }

    private boolean start(long start) {
        this.start = start;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMarshallableSize(long start, BytesIn bytes) {
        long rp = bytes.readPosition();
        try {
            bytes.readPosition(start);
            boolean bl = bytes.readLimit() - start == (long)VanillaMessageHistory.marshallableSize(bytes);
            return bl;
        }
        finally {
            bytes.readPosition(rp);
        }
    }

    public void addSource(int id, long index) {
        this.sourceIdArray[this.sources] = id;
        this.sourceIndexArray[this.sources++] = index;
    }

    public void addTiming(long l) {
        if (this.timings >= this.timingsArray.length) {
            throw new IllegalStateException("Have exceeded message history size: " + this.toString());
        }
        this.timingsArray[this.timings++] = l;
    }

    @Override
    public String toString() {
        return "VanillaMessageHistory{sources: [" + this.toStringSources() + "] timings: [" + this.toStringTimings() + "] addSourceDetails=" + this.addSourceDetails + '}';
    }

    private String toStringSources() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sources; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.sourceIdArray[i]).append("=0x").append(Long.toHexString(this.sourceIndexArray[i]));
        }
        return sb.toString();
    }

    private String toStringTimings() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.timings; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.timingsArray[i]);
        }
        return sb.toString();
    }
}

