/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParselet;

public abstract class AbstractGeneratedMethodReader
implements MethodReader {
    private final MarshallableIn in;
    protected final WireParselet debugLoggingParselet;
    private final Supplier<MethodReader> delegateSupplier;
    protected MessageHistory messageHistory;
    private MethodReader delegate;
    private boolean closeIn = false;
    private boolean closed;

    public AbstractGeneratedMethodReader(MarshallableIn in, WireParselet debugLoggingParselet, Supplier<MethodReader> delegateSupplier) {
        this.in = in;
        this.debugLoggingParselet = debugLoggingParselet;
        this.delegateSupplier = delegateSupplier;
    }

    protected abstract boolean readOneCall(WireIn var1);

    public boolean readOne0(DocumentContext context) {
        if (context.isMetaData()) {
            return false;
        }
        this.messageHistory().reset(context.sourceId(), context.index());
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return false;
        }
        wireIn.startEvent();
        Bytes<?> bytes = wireIn.bytes();
        while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
            long start = bytes.readPosition();
            if (!this.readOneCall(wireIn)) {
                return false;
            }
            wireIn.consumePadding();
            if (bytes.readPosition() != start) continue;
            Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes.readRemaining() + " bytes left.");
            break;
        }
        wireIn.endEvent();
        return true;
    }

    @Override
    public boolean readOne() {
        boolean shouldDelegate;
        this.throwExceptionIfClosed();
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = shouldDelegate = !this.readOne0(context);
            if (shouldDelegate) {
                context.rollbackOnClose();
            }
        }
        if (shouldDelegate) {
            return this.delegate().readOne();
        }
        return true;
    }

    @Override
    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        return null;
    }

    @Override
    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean lazyReadOne() {
        this.throwExceptionIfClosed();
        if (!this.in.peekDocument()) {
            return false;
        }
        return this.readOne();
    }

    @Override
    public MethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    protected <T> T checkRecycle(T o) {
        if (o == null || o.getClass().isArray()) {
            return null;
        }
        if (o instanceof Collection) {
            ((Collection)o).clear();
        }
        if (o instanceof Map) {
            ((Map)o).clear();
        }
        return o;
    }

    protected Object actualInvoke(Method method, Object o, Object[] objects) {
        try {
            return method.invoke(o, objects);
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    private MethodReader delegate() {
        if (this.delegate == null) {
            this.delegate = this.delegateSupplier.get();
        }
        return this.delegate;
    }

    protected static Method lookupMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            Jvm.setAccessible(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

