/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.analytics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.analytics.MuteBuilder;
import net.openhft.chronicle.core.internal.analytics.ReflectionUtil;
import net.openhft.chronicle.core.internal.analytics.ReflectiveBuilder;
import net.openhft.chronicle.core.internal.analytics.StandardMaps;
import org.jetbrains.annotations.NotNull;

public interface AnalyticsFacade {
    default public void sendEvent(@NotNull String name) {
        this.sendEvent(name, Collections.emptyMap());
    }

    public void sendEvent(@NotNull String var1, @NotNull Map<String, String> var2);

    @NotNull
    public static Builder builder(@NotNull String measurementId, @NotNull String apiSecret) {
        if (ReflectionUtil.analyticsPresent() && Jvm.getBoolean("chronicle.analytics.enable")) {
            return new ReflectiveBuilder(measurementId, apiSecret);
        }
        return MuteBuilder.INSTANCE;
    }

    @NotNull
    public static Builder standardBuilder(@NotNull String measurementId, @NotNull String apiSecret, @NotNull String appVersion) {
        Builder builder = AnalyticsFacade.builder(measurementId, apiSecret);
        AnalyticsFacade.standardEventParameters(appVersion).forEach(builder::putEventParameter);
        AnalyticsFacade.standardUserProperties().forEach(builder::putUserProperty);
        builder.withFrequencyLimit(4, 1L, TimeUnit.HOURS);
        return builder;
    }

    @NotNull
    public static Map<String, String> standardEventParameters(@NotNull String appVersion) {
        return StandardMaps.standardEventParameters(appVersion);
    }

    @NotNull
    public static Map<String, String> standardUserProperties() {
        return StandardMaps.standardUserProperties();
    }

    public static interface Builder {
        @NotNull
        public Builder putUserProperty(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder putEventParameter(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder withFrequencyLimit(int var1, long var2, @NotNull TimeUnit var4);

        @NotNull
        public Builder withErrorLogger(@NotNull Consumer<String> var1);

        @NotNull
        public Builder withDebugLogger(@NotNull Consumer<String> var1);

        @NotNull
        public Builder withClientIdFileName(@NotNull String var1);

        @NotNull
        public Builder withUrl(@NotNull String var1);

        @NotNull
        public Builder withReportDespiteJUnit();

        @NotNull
        public AnalyticsFacade build();
    }
}

