/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.wire.BytesInBinaryMarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ChronicleMethodReaderTest
extends ChronicleQueueTestBase {
    private final Queue<String> capturedOutput = new ConcurrentLinkedQueue<String>();
    private Path dataDir;

    @Before
    public void before() {
        this.dataDir = this.getTmpDir().toPath();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)this.dataDir).sourceId(1).testBlockSize().build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            VanillaMethodWriterBuilder methodWriterBuilder = excerptAppender.methodWriterBuilder(All.class);
            All events = (All)methodWriterBuilder.build();
            for (int i = 0; i < 24; ++i) {
                Method1Type m1 = new Method1Type();
                m1.text = "hello";
                m1.value = i;
                m1.number = i;
                events.method1(m1);
                Method2Type m2 = new Method2Type();
                m2.text = "goodbye";
                m2.value = ++i;
                m2.number = i;
                events.method2(m2);
            }
        }
    }

    @Test
    public void shouldNotFailOnEmptyQueue() {
        this.expectException("Failback to readonly tablestore");
        Path path = this.getTmpDir().toPath();
        path.toFile().mkdirs();
        this.basicReader(path).execute();
        Assert.assertTrue((boolean)this.capturedOutput.isEmpty());
    }

    @NotNull
    public ChronicleReader basicReader(Path path) {
        return new ChronicleReader().withBasePath(path).withMessageSink(this.capturedOutput::add).asMethodReader(All.class.getName());
    }

    @Test
    public void shouldNotFailWhenNoMetadata() throws IOException {
        this.expectException("Failback to readonly tablestore");
        Files.list(this.dataDir).filter(f -> f.getFileName().toString().endsWith(".cq4t")).findFirst().ifPresent(path -> path.toFile().delete());
        this.basicReader().execute();
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
    }

    @Test
    public void shouldIncludeMessageHistoryByDefault() {
        this.basicReader().execute();
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
    }

    @Ignore(value="TODO FIX")
    @Test
    public void shouldApplyIncludeRegexToHistoryMessagesAndBusinessMessages() {
        this.basicReader().withInclusionRegex("goodbye").asMethodReader(null).execute();
        Assert.assertFalse((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
    }

    @Test
    public void shouldBeAbleToReadFromReadOnlyFile() throws IOException {
        if (OS.isWindows()) {
            System.err.println("#460 read-only not supported on Windows");
            return;
        }
        Path queueFile = Files.list(this.dataDir).filter(f -> f.getFileName().toString().endsWith(".cq4")).findFirst().orElseThrow(() -> new AssertionError((Object)("Could not find queue file in directory " + this.dataDir)));
        Assert.assertTrue((boolean)queueFile.toFile().setWritable(false));
        this.basicReader().execute();
    }

    @Test
    public void shouldConvertEntriesToText() {
        this.basicReader().execute();
        long msgCount = this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).filter(s -> !s.contains("history:")).peek(System.out::println).count();
        Assert.assertEquals((long)24L, (long)msgCount);
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("  5,\n  104,\n  101,\n  108,\n  108,\n  111,")));
    }

    @Test
    public void shouldFilterByInclusionRegex() {
        this.basicReader().withInclusionRegex(".*good.*").execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.size());
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> Assert.assertThat((Object)msg, (Matcher)CoreMatchers.containsString((String)"goodbye")));
    }

    @Ignore(value="TODO FIX")
    @Test
    public void shouldFilterByMultipleInclusionRegex() {
        this.basicReader().withInclusionRegex(".*bye$").withInclusionRegex(".*o.*").execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.size());
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> Assert.assertThat((Object)msg, (Matcher)CoreMatchers.containsString((String)"goodbye")));
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> Assert.assertThat((Object)msg, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"hello"))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfInputDirectoryDoesNotExist() {
        this.basicReader().withBasePath(Paths.get("/does/not/exist", new String[0])).execute();
    }

    @Test
    public void shouldFilterByExclusionRegex() {
        this.basicReader().withExclusionRegex(".*good.*").execute();
        long msgCount = this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).filter(s -> !s.contains("history:")).count();
        Assert.assertEquals((long)12L, (long)msgCount);
        this.capturedOutput.forEach(msg -> Assert.assertThat((Object)msg, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"goodbye"))));
    }

    @Ignore(value="TODO FIX")
    @Test
    public void shouldFilterByMultipleExclusionRegex() {
        this.basicReader().withExclusionRegex(".*bye$").withExclusionRegex(".*ell.*").execute();
        Assert.assertEquals((long)0L, (long)this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count());
    }

    @Test
    public void shouldReturnNoMoreThanTheSpecifiedNumberOfMaxRecords() {
        this.basicReader().historyRecords(5L).execute();
        Assert.assertEquals((long)5L, (long)this.capturedOutput.stream().filter(s -> !s.contains("history:")).filter(msg -> !msg.startsWith("0x")).count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfSpecifiedIndexIsBeforeFirstIndex() {
        this.basicReader().withStartIndex(1L).execute();
    }

    @Test
    public void shouldNotRewindPastStartOfQueueWhenDisplayingHistory() {
        this.basicReader().historyRecords(Long.MAX_VALUE).execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.stream().filter(s -> !s.contains("history:")).filter(msg -> !msg.startsWith("0x")).count());
    }

    private ChronicleReader basicReader() {
        return this.basicReader(this.dataDir);
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    private static final class FiniteDocumentPollMethod
    implements Function<ExcerptTailer, DocumentContext> {
        private final int maxPollsReturningEmptyDocument;
        private int invocationCount;

        private FiniteDocumentPollMethod(int maxPollsReturningEmptyDocument) {
            this.maxPollsReturningEmptyDocument = maxPollsReturningEmptyDocument;
        }

        @Override
        public DocumentContext apply(ExcerptTailer excerptTailer) {
            DocumentContext documentContext = excerptTailer.readingDocument();
            if (!documentContext.isPresent()) {
                ++this.invocationCount;
                if (this.invocationCount >= this.maxPollsReturningEmptyDocument) {
                    throw new ArithmeticException("For testing purposes");
                }
            }
            return documentContext;
        }
    }

    private static final class RecordCounter
    implements Consumer<String> {
        private final AtomicLong recordCount = new AtomicLong();
        private final CountDownLatch latch = new CountDownLatch(1);

        private RecordCounter() {
        }

        @Override
        public void accept(String msg) {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!msg.startsWith("0x")) {
                this.recordCount.incrementAndGet();
            }
        }
    }

    static class Method2Type
    extends SelfDescribingMarshallable {
        String text;
        long value;
        double number;

        Method2Type() {
        }
    }

    static class Method1Type
    extends BytesInBinaryMarshallable {
        String text;
        long value;
        double number;

        Method1Type() {
        }
    }

    static interface All
    extends Method1,
    Method2 {
    }

    static interface Method2 {
        public void method2(Method2Type var1);
    }

    static interface Method1 {
        @MethodId(value=1L)
        public void method1(Method1Type var1);
    }
}

