/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;

public class MilliPauser
implements Pauser {
    private final AtomicBoolean pausing = new AtomicBoolean();
    private long pauseTimeMS;
    private long timePaused = 0L;
    private long countPaused = 0L;

    public MilliPauser(long pauseTimeMS) {
        this.pauseTimeMS = pauseTimeMS;
    }

    public MilliPauser pauseTimeMS(long pauseTimeMS) {
        this.pauseTimeMS = pauseTimeMS;
        return this;
    }

    public MilliPauser minPauseTimeMS(long pauseTimeMS) {
        this.pauseTimeMS = Math.min(this.pauseTimeMS, pauseTimeMS);
        if (this.pauseTimeMS < 1L) {
            this.pauseTimeMS = 1L;
        }
        return this;
    }

    public long pauseTimeMS() {
        return this.pauseTimeMS;
    }

    @Override
    public void reset() {
    }

    @Override
    public void pause() {
        this.doPauseMS(this.pauseTimeMS);
    }

    void doPauseMS(long delayMS) {
        long start = System.nanoTime();
        this.pausing.set(true);
        Jvm.pause(delayMS);
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
        ++this.countPaused;
    }

    @Override
    public void unpause() {
    }

    @Override
    public long timePaused() {
        return this.timePaused;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

