/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.analytics.Analytics;
import net.openhft.chronicle.core.internal.analytics.MuteAnalytics;
import net.openhft.chronicle.core.internal.analytics.VanillaAnalytics;
import org.jetbrains.annotations.NotNull;

public enum AnalyticsUtil {

    private static final boolean DISABLE_ANALYTICS = Optional.ofNullable(System.getProperty("chronicle.analytics.disable")).filter("true"::equals).isPresent();
    private static final int MAX_LIBRARIES = 1000;
    private static final Map<String, Map<String, Analytics>> INSTANCES = new ConcurrentHashMap<String, Map<String, Analytics>>();

    @NotNull
    public static Analytics acquire(@NotNull String libraryName, @NotNull String libraryVersion) {
        if (libraryVersion.endsWith("SNAPSHOT") || DISABLE_ANALYTICS || INSTANCES.size() >= 1000) {
            return MuteAnalytics.INSTANCE;
        }
        return INSTANCES.computeIfAbsent(libraryName, unused -> new ConcurrentHashMap()).computeIfAbsent(libraryVersion, v -> new VanillaAnalytics(libraryName, (String)v));
    }
}

