/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Test;

public class MultiThreadedRollTest
extends ChronicleQueueTestBase {
    final ExecutorService reader = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("reader"));

    @After
    public void after() {
        this.reader.shutdown();
    }

    @Test(timeout=10000L)
    public void test() throws ExecutionException, InterruptedException {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.currentTimeMillis(1000L);
        File path = this.getTmpDir();
        try (SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            wqueue.acquireAppender().writeText((CharSequence)"hello world");
            try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
                ExcerptTailer tailer = rqueue.createTailer();
                Future<?> f = this.reader.submit(() -> {
                    long index;
                    do {
                        try (DocumentContext documentContext = tailer.readingDocument();){
                            index = documentContext.index();
                            boolean present = documentContext.isPresent();
                            Jvm.pause((long)50L);
                        }
                    } while (index != 0x200000000L && !this.reader.isShutdown());
                });
                timeProvider.currentTimeMillis(2000L);
                ((StoreAppender)wqueue.acquireAppender()).writeEndOfCycleIfRequired();
                Jvm.pause((long)200L);
                wqueue.acquireAppender().writeText((CharSequence)"hello world");
                f.get();
            }
        }
    }
}

