/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TableStoreTest
extends QueueTestCommon {
    @Test
    public void acquireValueFor() {
        LongValue b;
        String file = OS.getTarget() + "/table-" + Time.uniqueId() + ".cq4t";
        new File(file).deleteOnExit();
        try (TableStore table = SingleTableBuilder.binary((String)file, (Metadata)Metadata.NoMeta.INSTANCE).build();){
            LongValue a = table.acquireValueFor((CharSequence)"a");
            b = table.acquireValueFor((CharSequence)"b");
            Assert.assertEquals((long)Long.MIN_VALUE, (long)a.getVolatileValue());
            Assert.assertTrue((boolean)a.compareAndSwapValue(Long.MIN_VALUE, 1L));
            Assert.assertEquals((long)Long.MIN_VALUE, (long)b.getVolatileValue());
            Assert.assertTrue((boolean)b.compareAndSwapValue(Long.MIN_VALUE, 2L));
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT\n}\n# position: 60, header: 0\n--- !!data #binary\na: 1\n# position: 80, header: 1\n--- !!data #binary\nb: 2\n...\n# 65436 bytes remaining\n", (Object)table.dump());
            Closeable.closeQuietly((Object[])new Object[]{a, b});
        }
        table = SingleTableBuilder.binary((String)file, (Metadata)Metadata.NoMeta.INSTANCE).build();
        var3_3 = null;
        try {
            LongValue c = table.acquireValueFor((CharSequence)"c");
            b = table.acquireValueFor((CharSequence)"b");
            Assert.assertEquals((long)Long.MIN_VALUE, (long)c.getVolatileValue());
            Assert.assertTrue((boolean)c.compareAndSwapValue(Long.MIN_VALUE, 3L));
            Assert.assertEquals((long)2L, (long)b.getVolatileValue());
            Assert.assertTrue((boolean)b.compareAndSwapValue(2L, 22L));
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT\n}\n# position: 60, header: 0\n--- !!data #binary\na: 1\n# position: 80, header: 1\n--- !!data #binary\nb: 22\n# position: 96, header: 2\n--- !!data #binary\nc: 3\n...\n# 65420 bytes remaining\n", (Object)table.dump());
            Closeable.closeQuietly((Object[])new Object[]{c, b});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var3_3 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }
}

