/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class InternalAppenderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicationTest() throws Exception {
        File file = Files.createTempDirectory("queue", new FileAttribute[0]).toFile();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)file).build();){
            long index = queue.rollCycle().toIndex(queue.cycle(), 0L);
            InternalAppender appender = (InternalAppender)queue.acquireAppender();
            appender.writeBytes(index, (BytesStore)Bytes.from((String)"Replicated"));
            try (SingleChronicleQueue app = SingleChronicleQueueBuilder.single((File)file).build();){
                app.acquireAppender().writeBytes(Bytes.from((String)"Written locally"));
            }
            appender.writeBytes(index + 2L, (BytesStore)Bytes.from((String)"Replicated 2"));
            Assert.assertEquals((long)queue.entryCount(), (long)3L);
        }
        finally {
            IOTools.deleteDirWithFiles((File)file);
        }
    }
}

