/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.GenerateMethodReader;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMethodReader;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMethodReaderBuilder
implements MethodReaderBuilder {
    public static final String DISABLE_READER_PROXY_CODEGEN = "disableReaderProxyCodegen";
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Class<?> COMPILE_FAILED = ClassNotFoundException.class;
    private final MarshallableIn in;
    private boolean warnMissing = false;
    private boolean ignoreDefaults;
    private WireParselet defaultParselet;
    private MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private WireType wireType;

    public VanillaMethodReaderBuilder(MarshallableIn in) {
        this.in = in;
    }

    @NotNull
    public static WireParselet createDefaultParselet(boolean warnMissing) {
        return (s, v) -> {
            MessageHistory history = MessageHistory.get();
            long sourceIndex = history.lastSourceIndex();
            v.skipValue();
            if (s.length() == 0 || warnMissing) {
                VanillaMethodReader.LOGGER.warn(VanillaMethodReaderBuilder.errorMsg(s, history, sourceIndex));
            } else if (VanillaMethodReader.LOGGER.isDebugEnabled()) {
                VanillaMethodReader.LOGGER.debug(VanillaMethodReaderBuilder.errorMsg(s, history, sourceIndex));
            }
        };
    }

    @NotNull
    private static String errorMsg(CharSequence s, MessageHistory history, long sourceIndex) {
        String identifierType = s.length() != 0 && Character.isDigit(s.charAt(0)) ? "@MethodId" : "method-name";
        return "Unknown " + identifierType + "='" + s + "' from " + history.lastSourceId() + " at " + Long.toHexString(sourceIndex) + " ~ " + (int)sourceIndex;
    }

    public boolean ignoreDefaults() {
        return this.ignoreDefaults;
    }

    @NotNull
    public MethodReaderBuilder ignoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
        return this;
    }

    public WireParselet defaultParselet() {
        return this.defaultParselet;
    }

    public MethodReaderBuilder defaultParselet(WireParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    @Override
    public VanillaMethodReaderBuilder methodReaderInterceptorReturns(MethodReaderInterceptorReturns methodReaderInterceptorReturns) {
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        return this;
    }

    public boolean warnMissing() {
        return this.warnMissing;
    }

    @Override
    public VanillaMethodReaderBuilder warnMissing(boolean warnMissing) {
        this.warnMissing = warnMissing;
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public VanillaMethodReaderBuilder wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @Nullable
    private MethodReader createGeneratedInstance(Supplier<MethodReader> vanillaSupplier, Object ... impls) {
        block6: {
            if (this.ignoreDefaults || Jvm.getBoolean("chronicle.mr_overload_dont_throw") || Jvm.getBoolean(DISABLE_READER_PROXY_CODEGEN)) {
                return null;
            }
            GenerateMethodReader generateMethodReader = new GenerateMethodReader(this.wireType, this.methodReaderInterceptorReturns, impls);
            String fullClassName = generateMethodReader.packageName() + "." + generateMethodReader.generatedClassName();
            try {
                try {
                    Class<?> generatedClass = Class.forName(fullClassName);
                    return this.instanceForGeneratedClass(vanillaSupplier, generatedClass, impls);
                }
                catch (ClassNotFoundException e) {
                    Class clazz = classCache.computeIfAbsent(fullClassName, name -> generateMethodReader.createClass());
                    if (clazz != null && clazz != COMPILE_FAILED) {
                        return this.instanceForGeneratedClass(vanillaSupplier, clazz, impls);
                    }
                }
            }
            catch (Throwable e) {
                classCache.put(fullClassName, COMPILE_FAILED);
                if (!Jvm.isDebug()) break block6;
                Jvm.debug().on(this.getClass(), e);
            }
        }
        return null;
    }

    @NotNull
    private MethodReader instanceForGeneratedClass(Supplier<MethodReader> vanillaSupplier, Class<?> generatedClass, Object[] impls) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = generatedClass.getConstructors()[0];
        WireParselet debugLoggingParselet = VanillaMethodReader::logMessage;
        return (MethodReader)constructor.newInstance(this.in, debugLoggingParselet, vanillaSupplier, this.methodReaderInterceptorReturns, impls);
    }

    @Override
    @NotNull
    public MethodReader build(Object ... impls) {
        WireParselet defaultParselet = this.defaultParselet == null ? VanillaMethodReaderBuilder.createDefaultParselet(this.warnMissing) : this.defaultParselet;
        Supplier<MethodReader> vanillaSupplier = () -> new VanillaMethodReader(this.in, this.ignoreDefaults, defaultParselet, this.methodReaderInterceptorReturns, impls);
        MethodReader generatedInstance = this.createGeneratedInstance(vanillaSupplier, impls);
        return generatedInstance == null ? vanillaSupplier.get() : generatedInstance;
    }
}

