/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public enum RollCycles implements RollCycle
{
    FIVE_MINUTELY("yyyyMMdd-HHmm'V'", 300000, 2048, 256, TimeUnit.MINUTES.toMillis(5L)),
    TEN_MINUTELY("yyyyMMdd-HHmm'X'", 600000, 2048, 256, TimeUnit.MINUTES.toMillis(10L)),
    TWENTY_MINUTELY("yyyyMMdd-HHmm'XX'", 1200000, 2048, 256, TimeUnit.MINUTES.toMillis(12L)),
    HALF_HOURLY("yyyyMMdd-HHmm'H'", 1800000, 2048, 256, TimeUnit.MINUTES.toMillis(30L)),
    FAST_HOURLY("yyyyMMdd-HH'F'", 3600000, 4096, 256, TimeUnit.HOURS.toMillis(1L)),
    TWO_HOURLY("yyyyMMdd-HH'II'", 0x6DDD00, 4096, 256, TimeUnit.HOURS.toMillis(2L)),
    FOUR_HOURLY("yyyyMMdd-HH'IV'", 14400000, 4096, 256, TimeUnit.HOURS.toMillis(4L)),
    SIX_HOURLY("yyyyMMdd-HH'VI'", 21600000, 4096, 256, TimeUnit.HOURS.toMillis(6L)),
    FAST_DAILY("yyyyMMdd'F'", 86400000, 4096, 256, TimeUnit.DAYS.toMillis(1L)),
    MINUTELY("yyyyMMdd-HHmm", 60000, 2048, 16, TimeUnit.MINUTES.toMillis(1L)),
    HOURLY("yyyyMMdd-HH", 3600000, 4096, 16, TimeUnit.HOURS.toMillis(1L)),
    DAILY("yyyyMMdd", 86400000, 8192, 64, TimeUnit.DAYS.toMillis(1L)),
    LARGE_HOURLY("yyyyMMdd-HH'L'", 3600000, 8192, 64, TimeUnit.DAYS.toMillis(1L)),
    LARGE_DAILY("yyyyMMdd'L'", 86400000, 32768, 128, TimeUnit.DAYS.toMillis(1L)),
    XLARGE_DAILY("yyyyMMdd'X'", 86400000, 131072, 256, TimeUnit.DAYS.toMillis(1L)),
    HUGE_DAILY("yyyyMMdd'H'", 86400000, 524288, 1024, TimeUnit.DAYS.toMillis(1L)),
    SMALL_DAILY("yyyyMMdd'S'", 86400000, 8192, 8, TimeUnit.DAYS.toMillis(1L)),
    LARGE_HOURLY_SPARSE("yyyyMMdd-HH'LS'", 3600000, 4096, 1024, TimeUnit.HOURS.toMillis(1L)),
    LARGE_HOURLY_XSPARSE("yyyyMMdd-HH'LX'", 3600000, 2048, 0x100000, TimeUnit.HOURS.toMillis(1L)),
    HUGE_DAILY_XSPARSE("yyyyMMdd'HX'", 86400000, 16384, 0x100000, TimeUnit.HOURS.toMillis(1L)),
    TEST_SECONDLY("yyyyMMdd-HHmmss'T'", 1000, 32768, 4, TimeUnit.SECONDS.toMillis(1L)),
    TEST4_SECONDLY("yyyyMMdd-HHmmss'T4'", 1000, 32, 4, TimeUnit.SECONDS.toMillis(1L)),
    TEST_HOURLY("yyyyMMdd-HH'T'", 3600000, 16, 4, TimeUnit.HOURS.toMillis(1L)),
    TEST_DAILY("yyyyMMdd'T1'", 86400000, 8, 1, TimeUnit.DAYS.toMillis(1L)),
    TEST2_DAILY("yyyyMMdd'T2'", 86400000, 16, 2, TimeUnit.DAYS.toMillis(1L)),
    TEST4_DAILY("yyyyMMdd'T4'", 86400000, 32, 4, TimeUnit.DAYS.toMillis(1L)),
    TEST8_DAILY("yyyyMMdd'T8'", 86400000, 128, 8, TimeUnit.DAYS.toMillis(1L));

    public static final RollCycles DEFAULT;
    private static final Iterable<RollCycles> VALUES;
    private final String format;
    private final int lengthInMillis;
    private final int cycleShift;
    private final int indexCount;
    private final int indexSpacing;
    private final long sequenceMask;
    private final long durationOfCycle;

    private RollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing, long durationOfCycle) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.indexCount = Maths.nextPower2(indexCount, 8);
        this.indexSpacing = Maths.nextPower2(indexSpacing, 1);
        this.cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
        this.durationOfCycle = durationOfCycle;
    }

    @Override
    public long durationOfCycle() {
        return this.durationOfCycle;
    }

    @Override
    public long maxMessagesPerCycle() {
        return RollCycles.maxMessagesPerCycle(this.indexCount, this.indexSpacing);
    }

    public static Iterable<RollCycles> all() {
        return VALUES;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.indexCount;
    }

    @Override
    public int defaultIndexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public int current(@NotNull TimeProvider time, long epoch) {
        return (int)((time.currentTimeMillis() - epoch) / (long)this.lengthInMillis());
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    @Override
    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    @Override
    public int toCycle(long index) {
        return Maths.toUInt31(index >> this.cycleShift);
    }

    public static long maxMessagesPerCycle(long indexCount0, int indexSpacing0) {
        long indexCount = Maths.nextPower2(indexCount0, 8L);
        int indexSpacing = Maths.nextPower2(indexSpacing0, 1);
        int cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        long sequenceMask0 = (1L << cycleShift) - 1L;
        return Math.min(sequenceMask0, indexCount * indexCount * (long)indexSpacing);
    }

    static {
        DEFAULT = FAST_DAILY;
        VALUES = Arrays.asList(RollCycles.values());
    }
}

