/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ToEndTest
extends ChronicleQueueTestBase {
    private static List<File> pathsToDelete = new LinkedList<File>();
    long lastCycle;
    private Map<ExceptionKey, Integer> exceptionKeyIntegerMap;

    @AfterClass
    public static void afterClass() {
        for (File file : pathsToDelete) {
            IOTools.shallowDeleteDirWithFiles((File)file);
        }
    }

    @Test
    public void missingCyclesToEndTest() {
        String path = OS.getTarget() + "/missingCyclesToEndTest-" + System.nanoTime();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider timeProvider = new SetTimeProvider();
        long now = 1470757797000L;
        long timeIncMs = 1001L;
        timeProvider.currentTimeMillis(now);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
            timeProvider.currentTimeMillis(now += timeIncMs);
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(2));
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(3));
            ExcerptTailer tailer = queue.createTailer().toEnd();
            try (DocumentContext dc = tailer.readingDocument();){
                if (dc.isPresent()) {
                    Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + dc.wire().read("msg").int32()));
                }
            }
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(4));
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertTrue((String)"Should be able to read entry in this cycle. Got NoDocumentContext.", (boolean)dc.isPresent());
                int i = dc.wire().read("msg").int32();
                Assert.assertEquals((String)("Should've read 4, instead we read: " + i), (long)4L, (long)i);
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            tailer.toStart();
            for (int j = 1; j <= 4; ++j) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    int i = dc.wire().read("msg").int32();
                    Assert.assertEquals((long)j, (long)i);
                    continue;
                }
            }
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                if (dc.isPresent()) {
                    Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + String.valueOf(dc.wire().read("msg").int32())));
                }
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(5));
            timeProvider.currentTimeMillis(now += timeIncMs * 5L);
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((long)5L, (long)dc.wire().read("msg").int32());
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void tailerToEndIncreasesRefCount() throws NoSuchFieldException, IllegalAccessException {
        String path = OS.getTarget() + "/toEndIncRefCount-" + System.nanoTime();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider time = new SetTimeProvider();
        long now = System.currentTimeMillis();
        time.currentTimeMillis(now);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)time).build();){
            StoreAppender appender = (StoreAppender)queue.acquireAppender();
            Field storeF1 = StoreAppender.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF1);
            SingleChronicleQueueStore store1 = (SingleChronicleQueueStore)storeF1.get(appender);
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
            StoreTailer tailer = (StoreTailer)queue.createTailer();
            tailer.toEnd();
            Field storeF2 = StoreTailer.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF2);
            SingleChronicleQueueStore store2 = (SingleChronicleQueueStore)storeF2.get(tailer);
            Assert.assertFalse((boolean)store2.isClosed());
        }
    }

    @Test
    public void toEndTest() {
        File baseDir = this.getTmpDir();
        ArrayList<Integer> results = new ArrayList<Integer>();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).indexCount(8).indexSpacing(1).build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            int i = 0;
            while (i < 10) {
                int j = i++;
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(j));
            }
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer atEnd = tailer.toEnd();
            Assert.assertEquals((long)10L, (long)queue.rollCycle().toSequenceNumber(atEnd.index()));
            this.checkOneFile(baseDir);
            this.fillResults(atEnd, results);
            this.checkOneFile(baseDir);
            Assert.assertEquals((long)0L, (long)results.size());
            tailer.toStart();
            this.checkOneFile(baseDir);
            this.fillResults(tailer, results);
            Assert.assertEquals((long)10L, (long)results.size());
            this.checkOneFile(baseDir);
        }
        System.gc();
        pathsToDelete.add(baseDir);
    }

    @Test
    public void toEndBeforeWriteTest() {
        File baseDir = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)baseDir);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer2 = queue.createTailer();
            this.checkOneFile(baseDir);
            tailer.toEnd();
            this.checkOneFile(baseDir);
            tailer2.toEnd();
            this.checkOneFile(baseDir);
        }
        System.gc();
        pathsToDelete.add(baseDir);
    }

    @Test
    public void toEndAfterWriteTest() {
        File file = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)file);
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(1470757797000L);
        try (SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = wqueue.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().getValueOut().text("hi-" + i);
                    this.lastCycle = wqueue.rollCycle().toCycle(dc.index());
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            }
        }
        var4_4 = null;
        try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptTailer tailer = rqueue.createTailer();
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            while (tailer.readText() != null) {
            }
            Assert.assertNull((Object)tailer.readText());
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            ExcerptTailer tailer1 = rqueue.createTailer();
            ExcerptTailer excerptTailer = tailer1.toEnd();
            Assert.assertNull((Object)excerptTailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        System.gc();
        pathsToDelete.add(file);
    }

    private void checkOneFile(@NotNull File baseDir) {
        Object[] files = baseDir.list((d, n) -> n.endsWith(".cq4"));
        if (files == null || files.length == 0) {
            return;
        }
        if (files.length == 1) {
            Assert.assertTrue((String)files[0], (boolean)files[0].startsWith("2"));
        } else {
            Assert.fail((String)("Too many files " + Arrays.toString(files)));
        }
    }

    @NotNull
    private List<Integer> fillResults(@NotNull ExcerptTailer tailer, @NotNull List<Integer> results) {
        for (int i = 0; i < 10; ++i) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) break;
                results.add(documentContext.wire().read("msg").int32());
                continue;
            }
        }
        return results;
    }

    @Before
    public void enableCloseableTracing() {
        AbstractCloseable.enableCloseableTracing();
    }

    @After
    public void assertCloseablesClosed() {
        AbstractCloseable.assertCloseablesClosed();
    }
}

