/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class WriteReadTextTest
extends QueueTestCommon {
    private static final String CONSTRUCTED = "[\"abc\",\"comm_link\",[[1469743199691,1469743199691],[\"ABCDEFXH\",\"ABCDEFXH\"],[321,456],[\"\",\"\"]]]";
    @NotNull
    private static final String EXTREMELY_LARGE;
    private static final String MINIMAL = "[\"abc\"]";
    private static final String REALISTIC = "[\"abc\",\"comm_link\",[[1469743199691,1469743199691],[\"ABCDEFXH\",\"ABCDEFXH\"],[321,456],[-1408156298,-841885387],[12345,9876],[-841885387,-1408156298],[9876,12345],[0,0],[\"FIX.4.2\",\"FIX.4.2\"],[243,324],[\"NewOrderSingle\",\"ExecutionReport\"],[12862,13622],[\"Q1W2E3R4T5Y6U7I8O9P0\",\"ABC\"],[\"ABCDEFXH\",\"X\"],[1469743199686,1469743199691],[\"ABC\",\"Q1W2E3R4T5Y6U7I8O9P0\"],[\"X\",\"ABCDEFXH\"],[\"RU,IT\",\"\"],[13621,12862],[\"76537\",\"76537\"],[\"12345\",\"12345\"],[\"AUTOMATED_EXECUTION_ORDER_PRIVATE_NO_BROKER_INTERVENTION\",\"\"],[\"\",\"683895170272\"],[10,10],[\"LIMIT\",\"LIMIT\"],[\"\",\"0\"],[473100.0,473100.0],[\"SELL\",\"SELL\"],[\"NQ\",\"NQ\"],[\"DAY\",\"DAY\"],[1469743199686,1469743199691],[\"IJK123\",\"IJK123\"],[\"FUTURE\",\"FUTURE\"],[\"CRUTOMER\",\"\"],[true,true],[false,false],[\"\",\"\"],[\"\",\"\"],[\"NFY_9\",\"\"],[\"12345\",\"12345\"],\"\",[31,55],[\"\",\"RU,IT\"],[\"NaN\",0.0],[-2147483648,0],[\"\",\"68250:27217624\"],[\"\",\"NEW\"],[\"\",\"NEW\"],[-2147483648,2563],[\"\",\"NEW\"],[-2147483648,10],[null,1469750400000],[-2147483648,-2147483648],[\"NaN\",\"NaN\"],[-2147483648,-2147483648],[null,null],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],\"\",[-2147483648,-2147483648],[\"\",\"\"],[\"\",\"\"],[-2147483648,-2147483648],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[\"\",\"\"],[false,false],[-2147483648,-2147483648],[-2147483648,-2147483648],[-2147483648,-2147483648],[null,null],[-2147483648,-2147483648],[\"\",\"\"],[\"NaN\",\"NaN\"],[-2147483648,-2147483648],[\"\",\"\"],[-2147483648,-2147483648],[\"\",\"\"],[\"\",\"\"]]]";

    @Test
    public void testConstructed() {
        this.doTest(CONSTRUCTED);
    }

    @Test
    public void testExtremelyLarge() {
        this.doTest(EXTREMELY_LARGE);
    }

    @Test
    public void testMinimal() {
        this.doTest(MINIMAL);
    }

    @Test
    public void testRealistic() {
        this.doTest(REALISTIC);
    }

    private void doTest(String ... problematic) {
        String myPath = OS.getTarget() + "/writeReadText-" + System.nanoTime();
        try (SingleChronicleQueue theQueue = SingleChronicleQueueBuilder.single((String)myPath).blockSize(Maths.nextPower2((int)(EXTREMELY_LARGE.length() * 4), (int)262144)).build();){
            int p;
            int l;
            ExcerptAppender appender = theQueue.acquireAppender();
            ExcerptTailer tailer = theQueue.createTailer();
            StringBuilder tmpReadback = new StringBuilder();
            int tmpNumberOfIterations = 5;
            for (l = 0; l < 5; ++l) {
                for (p = 0; p < problematic.length; ++p) {
                    appender.writeText((CharSequence)problematic[p]);
                }
                for (p = 0; p < problematic.length; ++p) {
                    tailer.readText(tmpReadback);
                    Assert.assertEquals((String)"write/readText", (Object)problematic[p], (Object)tmpReadback.toString());
                }
            }
            for (l = 0; l < 5; ++l) {
                for (p = 0; p < problematic.length; ++p) {
                    String tmpText = problematic[p];
                    appender.writeDocument(writer -> writer.getValueOut().text(tmpText));
                    tailer.readDocument(reader -> reader.getValueIn().textTo(tmpReadback));
                    String actual = tmpReadback.toString();
                    Assert.assertEquals((long)problematic[p].length(), (long)actual.length());
                    for (int i = 0; i < actual.length(); i += 1024) {
                        Assert.assertEquals((String)("i: " + i), (Object)problematic[p].substring(i, Math.min(actual.length(), i + 1024)), (Object)actual.substring(i, Math.min(actual.length(), i + 1024)));
                    }
                    Assert.assertEquals((Object)problematic[p], (Object)actual);
                }
            }
        }
    }

    @After
    public void checkRegisteredBytes() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    static {
        int largest = 20993248;
        StringBuilder tmpSB = new StringBuilder(largest + 6);
        while (tmpSB.length() < largest) {
            tmpSB.append("0123456789ABCDE\n");
        }
        EXTREMELY_LARGE = tmpSB.toString();
    }
}

