/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class TableStorePutGetTest
extends QueueTestCommon {
    @Test
    public void indexEntry() {
        SetTimeProvider stp = new SetTimeProvider("2020/10/15T01:01:01");
        try (SingleChronicleQueue cq = ChronicleQueue.singleBuilder((String)(OS.getTarget() + "/indexEntry-" + System.nanoTime())).rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).testBlockSize().build();){
            try (ExcerptAppender appender = cq.acquireAppender();){
                try (DocumentContext dc = appender.acquireWritingDocument(false);){
                    dc.wire().write((CharSequence)"hello").text("world");
                }
                cq.tableStorePut((CharSequence)"=hello", appender.lastIndexAppended());
            }
            var5_7 = null;
            try (ExcerptTailer tailer = cq.createTailer();){
                long index = cq.tableStoreGet((CharSequence)"=hello");
                Assert.assertEquals((long)79671643340800L, (long)index);
                Assert.assertTrue((boolean)tailer.moveToIndex(index));
                Assert.assertEquals((long)index, (long)tailer.index());
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertEquals((Object)"hello", (Object)dc.wire().readEvent(String.class));
                    Assert.assertEquals((Object)"world", (Object)dc.wire().getValueIn().text());
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 176, header: 0\n--- !!data #binary\nlisting.highestCycle: 18550\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 18550\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 1\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 376, header: 5\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 432, header: 6\n--- !!data #binary\n=hello: 79671643340800\n...\n# 65076 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 296, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 392, header: 0\n--- !!data #binary\nhello: world\n...\n# 130660 bytes remaining\n", (Object)cq.dump());
        }
    }

    @Test
    public void manyEntries() {
        try (SingleChronicleQueue cq = ChronicleQueue.singleBuilder((String)(OS.getTarget() + "/manyEntries-" + System.nanoTime())).rollCycle((RollCycle)RollCycles.TEST_DAILY).testBlockSize().build();){
            for (int i = 0; i < 10000; ++i) {
                cq.tableStorePut((CharSequence)("=hello" + i), (long)i);
            }
        }
    }
}

