/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ReadWriteTest
extends QueueTestCommon {
    private static final String STR1 = "hello";
    private static final String STR2 = "hey";
    private File chroniclePath;

    @Before
    public void setup() {
        this.chroniclePath = new File(OS.getTarget(), "read_only_" + System.currentTimeMillis());
        try (SingleChronicleQueue readWrite = ChronicleQueue.singleBuilder((File)this.chroniclePath).readOnly(false).testBlockSize().build();){
            ExcerptAppender appender = readWrite.acquireAppender();
            appender.writeText((CharSequence)STR1);
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeUtf8(STR2);
            }
        }
    }

    @After
    public void teardown() {
        try {
            IOTools.shallowDeleteDirWithFiles((File)this.chroniclePath);
        }
        catch (Exception e) {
            if (e instanceof AccessDeniedException && OS.isWindows()) {
                System.err.println(e);
            }
            throw e;
        }
    }

    @Test
    public void testReadFromReadOnlyChronicle() {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            Assert.assertTrue((out.dump().length() > 1 ? 1 : 0) != 0);
            ExcerptTailer tailer = out.createTailer();
            Assert.assertEquals((Object)STR1, (Object)tailer.readText());
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)STR2, (Object)dc.wire().bytes().readUtf8());
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteToReadOnlyChronicle() {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test read only mode on windows");
            throw new IllegalStateException("not run");
        }
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            out.acquireAppender();
        }
    }

    @Test
    public void testToEndOnReadOnly() {
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertTrue((index != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNonWriteableFilesSetToReadOnly() {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.expectException("Failback to readonly tablestore");
        Arrays.stream(this.chroniclePath.list()).forEach(s -> Assert.assertTrue((boolean)new File(this.chroniclePath, (String)s).setWritable(false)));
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(false).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertTrue((index != 0L ? 1 : 0) != 0);
        }
    }
}

