/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class MethodReaderObjectReuseTest
extends QueueTestCommon {
    @Test
    public void testOneOne() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{PingDTO.class});
        try (SingleChronicleQueue cq = SingleChronicleQueueBuilder.single((String)(OS.getTarget() + "/MethodReaderObjectReuseTest-" + System.nanoTime())).build();){
            ++PingDTO.constructionExpected;
            PingDTO pdtio = new PingDTO();
            ++PingDTO.constructionExpected;
            Pinger pinger = (Pinger)cq.acquireAppender().methodWriter(Pinger.class, new Class[0]);
            for (int i = 0; i < 5; ++i) {
                pinger.ping(pdtio);
                Assert.assertEquals((long)PingDTO.constructionExpected, (long)PingDTO.constructionCounter);
                pdtio.bytes.append((CharSequence)"hi");
            }
            StringBuilder sb = new StringBuilder();
            MethodReader reader = cq.createTailer().methodReader(new Object[]{pingDTO -> sb.append("ping ").append((Object)pingDTO)});
            Assert.assertEquals((long)(++PingDTO.constructionExpected), (long)PingDTO.constructionCounter);
            while (reader.readOne()) {
            }
            Assert.assertEquals((Object)"ping !PingDTO {\n  bytes: \"\"\n}\nping !PingDTO {\n  bytes: hi\n}\nping !PingDTO {\n  bytes: hihi\n}\nping !PingDTO {\n  bytes: hihihi\n}\nping !PingDTO {\n  bytes: hihihihi\n}\n", (Object)sb.toString());
        }
    }

    static class PingDTO
    extends SelfDescribingMarshallable {
        static int constructionCounter;
        static int constructionExpected;
        final Bytes bytes = Bytes.allocateElasticOnHeap();

        PingDTO() {
            if (++constructionCounter > constructionExpected) {
                throw new AssertionError();
            }
        }
    }

    @FunctionalInterface
    static interface Pinger {
        public void ping(PingDTO var1);
    }
}

