/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.util.FileState;
import net.openhft.chronicle.queue.util.FileUtil;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class FileUtilTest
extends ChronicleQueueTestBase {
    @Test
    public void stateNonExisting() {
        Assume.assumeFalse((boolean)OS.isWindows());
        Assert.assertEquals((Object)FileState.NON_EXISTENT, (Object)FileUtil.state((File)new File("sjduq867q3jqq3t3q3r")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void state() throws IOException {
        AbstractCloseable.disableCloseableTracing();
        Assume.assumeFalse((boolean)OS.isWindows());
        Path dir = IOTools.createTempDirectory((String)"openByAnyProcess");
        dir.toFile().mkdir();
        try {
            File testFile = dir.resolve("tmpFile").toFile();
            Files.write(testFile.toPath(), "A".getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            Assert.assertEquals((Object)FileState.CLOSED, (Object)FileUtil.state((File)testFile));
            try (BufferedReader br = new BufferedReader(new FileReader(testFile));){
                Assert.assertEquals((Object)FileState.OPEN, (Object)FileUtil.state((File)testFile));
            }
            Assert.assertEquals((Object)FileState.CLOSED, (Object)FileUtil.state((File)testFile));
        }
        finally {
            IOTools.deleteDirWithFiles((File)dir.toFile());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void stateWindows() {
        AbstractCloseable.disableCloseableTracing();
        Assume.assumeTrue((boolean)OS.isWindows());
        FileUtil.state((File)new File("foo"));
    }

    @Test
    public void hasQueueSuffixFalse() {
        File file = new File("foo");
        Assert.assertFalse((boolean)FileUtil.hasQueueSuffix((File)file));
    }

    @Test
    public void hasQueueSuffixTrue() {
        File file = new File("a.cq4");
        Assert.assertTrue((boolean)FileUtil.hasQueueSuffix((File)file));
    }

    @Ignore(value="TODO FIX https://github.com/OpenHFT/Chronicle-Core/issues/121")
    @Test
    public void removableQueueFileCandidates() {
        Assume.assumeFalse((boolean)OS.isWindows());
        int rolls = 4;
        int intermediateRolls = 2;
        Comparator<File> earliestFirst = Comparator.comparing(File::getName);
        SetTimeProvider tp = new SetTimeProvider(0L);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, WireType.BINARY).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)tp).build();){
            String text;
            String text2;
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 4; ++i) {
                appender.writeText((CharSequence)Integer.toString(i));
                tp.advanceMillis(1000L);
            }
            Jvm.pause((long)1000L);
            tailer.toStart();
            File[] files = tmpDir.listFiles(FileUtil::hasQueueSuffix);
            Assert.assertNotNull((Object)files);
            List createdFiles = Stream.of(files).sorted(earliestFirst).collect(Collectors.toList());
            List candidatesBeforeTailing = FileUtil.removableRollFileCandidates((File)tmpDir).collect(Collectors.toList());
            this.assertSorted(candidatesBeforeTailing, earliestFirst);
            Assert.assertEquals(Collections.emptyList(), candidatesBeforeTailing);
            for (int i = 0; i < 2 && (text2 = tailer.readText()) != null; ++i) {
            }
            Jvm.pause((long)1000L);
            List candidatesAfterIntermediateTailing = FileUtil.removableRollFileCandidates((File)tmpDir).collect(Collectors.toList());
            this.assertSorted(candidatesAfterIntermediateTailing, earliestFirst);
            Assert.assertEquals(createdFiles.subList(0, 1), candidatesAfterIntermediateTailing);
            for (int i = 2; i < 4 && (text = tailer.readText()) != null; ++i) {
            }
            Jvm.pause((long)1000L);
            List candidatesAfterAllTailing = FileUtil.removableRollFileCandidates((File)tmpDir).collect(Collectors.toList());
            this.assertSorted(candidatesAfterAllTailing, earliestFirst);
            Assert.assertEquals(createdFiles.subList(0, 3), candidatesAfterAllTailing);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removableQueueFileCandidatesWindows() {
        Assume.assumeTrue((boolean)OS.isWindows());
        AbstractCloseable.disableCloseableTracing();
        FileUtil.removableRollFileCandidates((File)new File("foo"));
    }

    private <T> void assertSorted(List<T> list, Comparator<T> comparator) {
        Assert.assertEquals(list.stream().sorted(comparator).collect(Collectors.toList()), list);
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }
}

