/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.reader.ChronicleHistoryReader;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChronicleHistoryReaderTest
extends QueueTestCommon {
    @Test
    public void testWithQueueHistoryRecordHistoryInitial() {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.doTest(true);
    }

    @Test
    public void testWithQueueHistory() {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.doTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(boolean recordHistoryFirst) {
        VanillaMessageHistory veh = new VanillaMessageHistory();
        veh.addSourceDetails(true);
        MessageHistory.set((MessageHistory)veh);
        int extraTiming = recordHistoryFirst ? 1 : 0;
        long nanoTime = System.nanoTime();
        File queuePath = new File(OS.TARGET, "testWithQueueHistory-" + nanoTime);
        File queuePath2 = new File(OS.TARGET, "testWithQueueHistory2-" + nanoTime);
        File queuePath3 = new File(OS.TARGET, "testWithQueueHistory3-" + nanoTime);
        try {
            MethodReader reader;
            DummyListener dummy;
            DummyListener writer3;
            Throwable throwable;
            SingleChronicleQueue out3;
            try (SingleChronicleQueue out2 = ChronicleQueue.singleBuilder((File)queuePath).testBlockSize().sourceId(1).build();){
                DummyListener writer2 = (DummyListener)out2.acquireAppender().methodWriterBuilder(DummyListener.class).recordHistory(recordHistoryFirst).get();
                writer2.say("hello");
            }
            var10_10 = null;
            try (SingleChronicleQueue in = ChronicleQueue.singleBuilder((File)queuePath).testBlockSize().sourceId(1).build();){
                out3 = ChronicleQueue.singleBuilder((File)queuePath2).testBlockSize().sourceId(2).build();
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(DummyListener.class).recordHistory(true).get();
                    dummy = msg -> {
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)1L, (long)history.sources());
                        Assert.assertEquals((long)(1 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable writer3) {
                    throwable = writer3;
                    throw writer3;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable writer3) {
                                throwable.addSuppressed(writer3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable out3) {
                var10_10 = out3;
                throw out3;
            }
            in = ChronicleQueue.singleBuilder((File)queuePath2).testBlockSize().sourceId(2).build();
            var10_10 = null;
            try {
                out3 = ChronicleQueue.singleBuilder((File)queuePath3).testBlockSize().sourceId(3).build();
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(DummyListener.class).recordHistory(true).get();
                    dummy = msg -> {
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)2L, (long)history.sources());
                        Assert.assertEquals((long)(3 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                var10_10 = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (var10_10 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            var10_10.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            ChronicleHistoryReader chronicleHistoryReader = new ChronicleHistoryReader().withBasePath(queuePath3.toPath()).withTimeUnit(TimeUnit.MICROSECONDS).withMessageSink(s -> {});
            Map histos = chronicleHistoryReader.readChronicle();
            chronicleHistoryReader.outputData();
            if (recordHistoryFirst) {
                Assert.assertEquals((long)5L, (long)histos.size());
                Assert.assertEquals((Object)"[1, startTo1, 2, 1to2, endToEnd]", (Object)histos.keySet().toString());
            } else {
                Assert.assertEquals((long)4L, (long)histos.size());
                Assert.assertEquals((Object)"[1, 2, 1to2, endToEnd]", (Object)histos.keySet().toString());
            }
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((File)queuePath);
                IOTools.shallowDeleteDirWithFiles((File)queuePath2);
                IOTools.shallowDeleteDirWithFiles((File)queuePath3);
            }
            catch (Exception exception) {}
        }
    }

    @FunctionalInterface
    private static interface DummyListener {
        public void say(String var1);
    }
}

