/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SingleChronicleQueueStoreTest
extends QueueTestCommon {
    private static final int INDEX_SPACING = 4;
    private static final int RECORD_COUNT = 40;
    private static final RollCycles ROLL_CYCLE = RollCycles.DAILY;
    private static final ReferenceOwner test = ReferenceOwner.temporary((String)"test");
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    private static void assertExcerptsAreIndexed(RollingChronicleQueue queue, long[] indices, Function<Integer, Boolean> shouldBeIndexed, ScanResult expectedScanResult) {
        try (SingleChronicleQueueStore wireStore = queue.storeForCycle(queue.cycle(), 0L, true, null);
             StoreTailer tailer = (StoreTailer)queue.createTailer();){
            SCQIndexing indexing = wireStore.indexing;
            for (int i = 0; i < 40; ++i) {
                int startLinearScanCount = indexing.linearScanCount;
                ScanResult scanResult = indexing.moveToIndex((ExcerptContext)tailer, indices[i]);
                Assert.assertEquals((Object)expectedScanResult, (Object)scanResult);
                if (shouldBeIndexed.apply(i).booleanValue()) {
                    Assert.assertEquals((long)startLinearScanCount, (long)indexing.linearScanCount);
                    continue;
                }
                Assert.assertEquals((long)(startLinearScanCount + 1), (long)indexing.linearScanCount);
            }
        }
    }

    private static long[] writeMessagesStoreIndices(ExcerptAppender appender, ExcerptTailer tailer) {
        Throwable throwable;
        DocumentContext ctx;
        int i;
        long[] indices = new long[40];
        for (i = 0; i < 40; ++i) {
            ctx = appender.writingDocument();
            throwable = null;
            try {
                ctx.wire().getValueOut().int32(i);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        for (i = 0; i < 40; ++i) {
            ctx = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertTrue((String)("Expected record at index " + i), (boolean)ctx.isPresent());
                indices[i] = tailer.index();
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        return indices;
    }

    @Test
    public void shouldPerformIndexingOnAppend() throws IOException {
        this.runTest(queue -> {
            try (ExcerptAppender appender = queue.acquireAppender();){
                long[] indices = SingleChronicleQueueStoreTest.writeMessagesStoreIndices(appender, queue.createTailer());
                SingleChronicleQueueStoreTest.assertExcerptsAreIndexed(queue, indices, i -> i % 4 == 0, ScanResult.FOUND);
            }
        });
    }

    private <T extends Exception> void runTest(ThrowingConsumer<RollingChronicleQueue, T> testMethod) throws T, IOException {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.tmpDir.newFolder()).testBlockSize().timeProvider(this.clock::get).rollCycle((RollCycle)ROLL_CYCLE).indexSpacing(4).build();){
            testMethod.accept((Object)queue);
        }
    }
}

