/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import org.junit.Assert;
import org.junit.Test;

public final class ExcerptsSkippedWhenTailerDirectionNoneTest
extends QueueTestCommon {
    @Test
    public void shouldNotSkipMessageAtStartOfQueue() {
        File tmpDir = DirectoryUtils.tempDir(ExcerptsSkippedWhenTailerDirectionNoneTest.class.getSimpleName());
        try (SingleChronicleQueue writeQueue = ChronicleQueue.singleBuilder((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender excerptAppender = writeQueue.acquireAppender();
            try (DocumentContext ctx = excerptAppender.writingDocument();){
                ctx.wire().getValueOut().object((Object)"first");
            }
            ctx = excerptAppender.writingDocument();
            var6_10 = null;
            try {
                ctx.wire().getValueOut().object((Object)"second");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (ctx != null) {
                    if (var6_10 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        var3_3 = null;
        try (SingleChronicleQueue readQueue = ChronicleQueue.singleBuilder((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            String value;
            ValueIn valueIn;
            ExcerptTailer tailer = readQueue.createTailer();
            RollCycle rollCycle = readQueue.rollCycle();
            Assert.assertEquals((long)0L, (long)rollCycle.toSequenceNumber(tailer.index()));
            DocumentContext ctx = tailer.direction(TailerDirection.NONE).readingDocument();
            Throwable throwable = null;
            if (ctx != null) {
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ctx.close();
                }
            }
            Assert.assertEquals((long)0L, (long)rollCycle.toSequenceNumber(tailer.index()));
            try (DocumentContext dc = tailer.direction(TailerDirection.FORWARD).readingDocument();){
                valueIn = dc.wire().getValueIn();
                value = (String)valueIn.object();
            }
            Assert.assertEquals((long)1L, (long)rollCycle.toSequenceNumber(tailer.index()));
            Assert.assertEquals((Object)"first", (Object)value);
            dc = tailer.direction(TailerDirection.NONE).readingDocument();
            var8_18 = null;
            try {
                valueIn = dc.wire().getValueIn();
                value = (String)valueIn.object();
            }
            catch (Throwable valueIn2) {
                var8_18 = valueIn2;
                throw valueIn2;
            }
            finally {
                if (dc != null) {
                    if (var8_18 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable valueIn2) {
                            var8_18.addSuppressed(valueIn2);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((long)1L, (long)rollCycle.toSequenceNumber(tailer.index()));
            Assert.assertEquals((Object)"second", (Object)value);
            dc = tailer.direction(TailerDirection.NONE).readingDocument();
            var8_18 = null;
            try {
                valueIn = dc.wire().getValueIn();
                value = (String)valueIn.object();
            }
            catch (Throwable throwable3) {
                var8_18 = throwable3;
                throw throwable3;
            }
            finally {
                if (dc != null) {
                    if (var8_18 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable4) {
                            var8_18.addSuppressed(throwable4);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((long)1L, (long)rollCycle.toSequenceNumber(tailer.index()));
            Assert.assertEquals((Object)"second", (Object)value);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

