/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public final class DocumentOrderingTest
extends QueueTestCommon {
    private static final RollCycles ROLL_CYCLE = RollCycles.TEST_SECONDLY;
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("test"));
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final AtomicInteger counter = new AtomicInteger(0);
    Thread thread;

    private static void expectValue(int expectedValue, ExcerptTailer tailer) {
        try (DocumentContext documentContext = tailer.readingDocument();){
            Assert.assertTrue((boolean)documentContext.isPresent());
            Assert.assertEquals((long)expectedValue, (long)documentContext.wire().getValueIn().int32());
        }
    }

    @Test
    public void queuedWriteInPreviousCycleShouldRespectTotalOrdering() throws InterruptedException, TimeoutException, ExecutionException {
        try (SingleChronicleQueue queue = this.builder(DirectoryUtils.tempDir("document-ordering"), 1000L).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            excerptAppender.writeDocument((Object)"foo", ValueOut::text);
            DocumentContext firstOpenDocument = excerptAppender.writingDocument();
            firstOpenDocument.wire().getValueOut().int32(this.counter.getAndIncrement());
            Future<RecordInfo> secondDocumentInFirstCycle = this.attemptToWriteDocument((ChronicleQueue)queue);
            this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
            Future<RecordInfo> otherDocumentWriter = this.attemptToWriteDocument((ChronicleQueue)queue);
            firstOpenDocument.close();
            secondDocumentInFirstCycle.get(5L, TimeUnit.SECONDS);
            ExcerptTailer tailer = queue.createTailer();
            tailer.readingDocument().close();
            otherDocumentWriter.get();
            DocumentOrderingTest.expectValue(0, tailer);
            DocumentOrderingTest.expectValue(1, tailer);
            DocumentOrderingTest.expectValue(2, tailer);
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
        }
    }

    @Test
    public void multipleThreadsMustWaitUntilPreviousCycleFileIsCompleted() throws InterruptedException, TimeoutException, ExecutionException {
        File dir = DirectoryUtils.tempDir("document-ordering");
        try (SingleChronicleQueue queue = this.builder(dir, 5000L).build();
             SingleChronicleQueue queue2 = this.builder(dir, 5000L).build();
             SingleChronicleQueue queue3 = this.builder(dir, 5000L).build();
             SingleChronicleQueue queue4 = this.builder(dir, 5000L).build();){
            Future<RecordInfo> thirdWriter;
            Future<RecordInfo> secondWriter;
            Future<RecordInfo> firstWriter;
            ExcerptAppender excerptAppender = queue.acquireAppender();
            try (DocumentContext documentContext = excerptAppender.writingDocument();){
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
                firstWriter = this.attemptToWriteDocument((ChronicleQueue)queue2);
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                secondWriter = this.attemptToWriteDocument((ChronicleQueue)queue3);
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                thirdWriter = this.attemptToWriteDocument((ChronicleQueue)queue4);
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(2L));
                documentContext.wire().getValueOut().int32(this.counter.getAndIncrement());
            }
            firstWriter.get(5L, TimeUnit.SECONDS);
            secondWriter.get(5L, TimeUnit.SECONDS);
            thirdWriter.get(5L, TimeUnit.SECONDS);
            ExcerptTailer tailer = queue.createTailer();
            DocumentOrderingTest.expectValue(0, tailer);
            DocumentOrderingTest.expectValue(1, tailer);
            DocumentOrderingTest.expectValue(2, tailer);
            DocumentOrderingTest.expectValue(3, tailer);
        }
    }

    @Test
    public void shouldRecoverFromUnfinishedFirstMessageInPreviousQueue() throws InterruptedException, TimeoutException, ExecutionException {
        try (SingleChronicleQueue queue = this.builder(DirectoryUtils.tempDir("document-ordering"), 1000L).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            DocumentContext documentContext = excerptAppender.writingDocument();
            documentContext.wire().getValueOut().int32(this.counter.getAndIncrement());
            this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
            Future<RecordInfo> otherDocumentWriter = this.attemptToWriteDocument((ChronicleQueue)queue);
            this.expectCounterVaueOne(otherDocumentWriter);
            ExcerptTailer tailer = queue.createTailer();
            DocumentOrderingTest.expectValue(1, tailer);
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
        }
    }

    @Test
    public void codeWithinPriorDocumentMustExecuteBeforeSubsequentDocumentWhenQueueIsEmpty() throws InterruptedException, TimeoutException, ExecutionException {
        try (SingleChronicleQueue queue = this.builder(DirectoryUtils.tempDir("document-ordering"), 3000L).build();){
            Future<RecordInfo> otherDocumentWriter;
            ExcerptAppender excerptAppender = queue.acquireAppender();
            try (DocumentContext documentContext = excerptAppender.writingDocument();){
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
                otherDocumentWriter = this.attemptToWriteDocument((ChronicleQueue)queue);
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(2L));
                documentContext.wire().getValueOut().int32(this.counter.getAndIncrement());
            }
            this.expectCounterVaueOne(otherDocumentWriter);
            ExcerptTailer tailer = queue.createTailer();
            DocumentOrderingTest.expectValue(0, tailer);
            DocumentOrderingTest.expectValue(1, tailer);
        }
    }

    @Test
    public void codeWithinPriorDocumentMustExecuteBeforeSubsequentDocumentWhenQueueIsNotEmpty() throws InterruptedException, TimeoutException, ExecutionException {
        try (SingleChronicleQueue queue = this.builder(DirectoryUtils.tempDir("document-ordering"), 3000L).build();){
            Future<RecordInfo> otherDocumentWriter;
            ExcerptAppender excerptAppender = queue.acquireAppender();
            excerptAppender.writeDocument((Object)"foo", ValueOut::text);
            try (DocumentContext documentContext = excerptAppender.writingDocument();){
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
                otherDocumentWriter = this.attemptToWriteDocument((ChronicleQueue)queue);
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(2L));
                documentContext.wire().getValueOut().int32(this.counter.getAndIncrement());
            }
            this.expectCounterVaueOne(otherDocumentWriter);
            var6_7 = null;
            try (ExcerptTailer tailer = queue.createTailer();){
                try (DocumentContext documentContext = tailer.readingDocument();){
                    Assert.assertTrue((boolean)documentContext.isPresent());
                }
                DocumentOrderingTest.expectValue(0, tailer);
                DocumentOrderingTest.expectValue(1, tailer);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    public void expectCounterVaueOne(Future<RecordInfo> otherDocumentWriter) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Assert.assertEquals((long)1L, (long)otherDocumentWriter.get(5L, TimeUnit.SECONDS).counterValue);
        }
        catch (TimeoutException e) {
            StackTrace.forThread((Thread)this.thread).printStackTrace();
            throw e;
        }
    }

    private Future<RecordInfo> attemptToWriteDocument(ChronicleQueue queue) throws InterruptedException {
        CountDownLatch startedLatch = new CountDownLatch(1);
        Future<RecordInfo> future = this.executorService.submit(() -> {
            int counterValue;
            this.thread = Thread.currentThread();
            startedLatch.countDown();
            try (DocumentContext documentContext = queue.acquireAppender().writingDocument();){
                counterValue = this.counter.getAndIncrement();
                documentContext.wire().getValueOut().int32(counterValue);
            }
            return new RecordInfo(counterValue);
        });
        Assert.assertTrue((String)"Task did not start", (boolean)startedLatch.await(1L, TimeUnit.MINUTES));
        return future;
    }

    private SingleChronicleQueueBuilder builder(File dir, long timeoutMS) {
        return ChronicleQueue.singleBuilder((File)dir).testBlockSize().rollCycle((RollCycle)ROLL_CYCLE).timeProvider(this.clock::get).timeoutMS(timeoutMS);
    }

    @Before
    public void multiCPU() {
        Assume.assumeTrue((Runtime.getRuntime().availableProcessors() > 1 ? 1 : 0) != 0);
    }

    private static final class RecordInfo {
        private final int counterValue;

        RecordInfo(int counterValue) {
            this.counterValue = counterValue;
        }
    }
}

