/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RollingChronicleQueueTest
extends ChronicleQueueTestBase {
    @Test
    public void testCountExcerptsWhenTheCycleIsRolled() {
        AtomicLong time = new AtomicLong();
        File name = DirectoryUtils.tempDir("testCountExcerptsWhenTheCycleIsRolled");
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)name).testBlockSize().timeProvider(time::get).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = q.acquireAppender();
            time.set(0L);
            appender.writeText((CharSequence)"1. some  text");
            long start = appender.lastIndexAppended();
            appender.writeText((CharSequence)"2. some more text");
            appender.writeText((CharSequence)"3. some more text");
            time.set(TimeUnit.DAYS.toMillis(1L));
            appender.writeText((CharSequence)"4. some text - first cycle");
            time.set(TimeUnit.DAYS.toMillis(2L));
            time.set(TimeUnit.DAYS.toMillis(3L));
            time.set(TimeUnit.DAYS.toMillis(4L));
            appender.writeText((CharSequence)"5. some text - second cycle");
            appender.writeText((CharSequence)"some more text");
            long end = appender.lastIndexAppended();
            String expectedEagerFirstFile = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    564,\n    2422361554946\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 196,\n    lastIndex: 4\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  360,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 360, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 2\n  520,\n  564,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 520, header: 0\n--- !!data #binary\n\"1. some  text\"\n# position: 540, header: 1\n--- !!data #binary\n\"2. some more text\"\n# position: 564, header: 2\n--- !!data #binary\n\"3. some more text\"\n# position: 588, header: 2 EOF\n";
            String expectedEagerSecondFile = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    520,\n    2233382993920\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 196,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  360,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 360, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  520,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 520, header: 0\n--- !!data #binary\n\"4. some text - first cycle\"\n# position: 552, header: 0 EOF";
            String expectedEagerThirdFile = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    552,\n    2370821947393\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 196,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  360,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 360, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  520,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 520, header: 0\n--- !!data #binary\n\"5. some text - second cycle\"\n# position: 552, header: 1\n--- !!data #binary\nsome more text\n";
            Assert.assertEquals((long)5L, (long)q.countExcerpts(start, end));
            Thread.yield();
            String dump = q.dump();
            Assert.assertTrue((boolean)dump.contains(expectedEagerFirstFile));
            Assert.assertTrue((boolean)dump.contains(expectedEagerSecondFile));
            Assert.assertTrue((boolean)dump.contains(expectedEagerThirdFile));
        }
    }

    @Test
    public void testTailingWithEmptyCycles() {
        this.testTailing(p -> {
            try {
                p.execute();
            }
            catch (InvalidEventHandlerException e) {
                e.printStackTrace();
            }
            return 1;
        });
    }

    @Test
    public void testTailingWithMissingCycles() {
        this.testTailing(p -> 0);
    }

    private void testTailing(Function<Pretoucher, Integer> createGap) {
        SetTimeProvider tp = new SetTimeProvider(0L);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, WireType.BINARY).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)tp).build();
             Pretoucher pretoucher = new Pretoucher(queue);){
            String text;
            int cyclesAdded = 0;
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"0");
            Assert.assertEquals((long)1L, (long)tmpDir.listFiles(file -> file.getName().endsWith("cq4")).length);
            tp.advanceMillis(1000L);
            appender.writeText((CharSequence)"1");
            Assert.assertEquals((long)2L, (long)tmpDir.listFiles(file -> file.getName().endsWith("cq4")).length);
            tp.advanceMillis(2000L);
            Assert.assertEquals((long)(2 + (cyclesAdded += createGap.apply(pretoucher).intValue())), (long)tmpDir.listFiles(file -> file.getName().endsWith("cq4")).length);
            tp.advanceMillis(1000L);
            appender.writeText((CharSequence)"2");
            Assert.assertEquals((long)(3 + cyclesAdded), (long)tmpDir.listFiles(file -> file.getName().endsWith("cq4")).length);
            tp.advanceMillis(2000L);
            Assert.assertEquals((long)(3 + (cyclesAdded += createGap.apply(pretoucher).intValue())), (long)tmpDir.listFiles(file -> file.getName().endsWith("cq4")).length);
            int count = 0;
            ExcerptTailer tailer = queue.createTailer();
            long[] indexes = new long[3];
            while ((text = tailer.readText()) != null) {
                indexes[count] = tailer.index() - 1L;
                Assert.assertEquals((long)count++, (long)Integer.parseInt(text));
            }
            Assert.assertEquals((long)indexes.length, (long)count);
            tailer.toStart();
            for (int i = 0; i < indexes.length; ++i) {
                Assert.assertTrue((boolean)tailer.moveToIndex(indexes[i]));
                String text2 = tailer.readText();
                Assert.assertEquals((long)i, (long)Integer.parseInt(text2));
            }
        }
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }
}

