/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wires;
import org.junit.Assert;
import org.junit.Test;

public class RawAccessJava {
    final long QUEUE_HEADER_SIZE = 4L;
    final long RAW_SIZE_PREFIX = 4L;
    final long COUNT = 10L;

    boolean assert_from_cpp() {
        String env = System.getProperty("chronicle.test.env");
        return env != null && env.equals("from-cpp");
    }

    @Test
    public void Tailer() {
        if (!this.assert_from_cpp()) {
            return;
        }
        String tmp = "/dev/shm/RawAccessCtoJ";
        try (SingleChronicleQueue cq = SingleChronicleQueueBuilder.binary((String)tmp).build();){
            ExcerptTailer tailer = cq.createTailer();
            int i = 0;
            while ((long)i < 10L) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Bytes bytes = dc.wire().bytes();
                    bytes.readSkip(-4L);
                    int header = bytes.readInt();
                    int length = Wires.lengthOf((int)header);
                    int data_length = bytes.readInt();
                    Assert.assertEquals((long)bytes.readByte(), (long)-85L);
                    Assert.assertEquals((long)bytes.readShort(), (long)12L);
                    Assert.assertEquals((long)bytes.readInt(), (long)123L);
                    Assert.assertEquals((long)bytes.readLong(), (long)123456789L);
                    Assert.assertEquals((double)bytes.readFloat(), (double)1.234f, (double)1.0E-7);
                    Assert.assertEquals((double)bytes.readDouble(), (double)123.456, (double)1.0E-7);
                    Assert.assertEquals((long)bytes.readChar(), (long)97L);
                    StringBuilder sb = new StringBuilder();
                    bytes.read8bit(sb);
                    Assert.assertEquals((Object)sb.toString(), (Object)"Hello World");
                }
                ++i;
            }
        }
    }

    @Test
    public void Appender() {
        if (!this.assert_from_cpp()) {
            return;
        }
        String tmp = "/dev/shm/RawAccessJtoC";
        try (SingleChronicleQueue cq = SingleChronicleQueueBuilder.binary((String)tmp).build();){
            ExcerptAppender appender = cq.acquireAppender();
            int i = 0;
            while ((long)i < 10L) {
                try (DocumentContext dc = appender.writingDocument();){
                    Bytes bytes = dc.wire().bytes();
                    long start = bytes.writePosition();
                    bytes.writeSkip(4L);
                    bytes.writeByte((byte)-85);
                    bytes.writeShort((short)12);
                    bytes.writeInt(123);
                    bytes.writeLong(123456789L);
                    bytes.writeFloat(1.234f);
                    bytes.writeDouble(123.456);
                    bytes.writeChar('a');
                    bytes.write8bit("Hello World");
                    long end = bytes.writePosition();
                    bytes.writeInt(start, (int)(end - start - 4L));
                }
                ++i;
            }
        }
    }
}

