/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RareAppenderLatencyTest
extends QueueTestCommon {
    private static final int HEAVY_MSGS = 1000000;
    private static final int RARE_MSGS = 50;
    boolean isAssertionsOn;
    private ExecutorService appenderES;

    @Before
    public void before() {
        this.appenderES = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Appender", Boolean.valueOf(false)));
    }

    @After
    public void after() {
        this.appenderES.shutdownNow();
    }

    @Test
    public void testRareAppenderLatency() throws InterruptedException, ExecutionException {
        System.setProperty("ignoreHeaderCountIfNumberOfExcerptsBehindExceeds", "4096");
        if (Jvm.isDebug()) {
            return;
        }
        if (!$assertionsDisabled) {
            this.isAssertionsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (this.isAssertionsOn) {
            return;
        }
        String pathname = OS.getTarget() + "/testRareAppenderLatency-" + System.nanoTime();
        new File(pathname).deleteOnExit();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)pathname).rollCycle((RollCycle)RollCycles.HOURLY).build();
        String text = this.getText();
        ExcerptAppender rareAppender = queue.acquireAppender();
        for (int i = 0; i < 50; ++i) {
            try (DocumentContext ctx = rareAppender.writingDocument();){
                ctx.wire().write(() -> "ts").int64(System.currentTimeMillis()).write(() -> "msg").text(text);
                continue;
            }
        }
        Future<?> f = this.appenderES.submit(() -> this.lambda$testRareAppenderLatency$4((ChronicleQueue)queue, text));
        f.get();
        rareAppender = queue.acquireAppender();
        long now = System.currentTimeMillis();
        try (DocumentContext ctx = rareAppender.writingDocument();){
            ctx.wire().write(() -> "ts").int64(System.currentTimeMillis()).write(() -> "msg").text(text);
        }
        long l = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        try (DocumentContext ctx = rareAppender.writingDocument();){
            ctx.wire().write(() -> "ts").int64(System.currentTimeMillis()).write(() -> "msg").text(text);
        }
        System.out.println("Wrote first rare one in " + l + " ms");
        System.out.println("Wrote another rare one in " + (System.currentTimeMillis() - now) + " ms");
        TestCase.assertFalse((String)"Appending from rare thread latency too high!", (l > 150L ? 1 : 0) != 0);
    }

    @NotNull
    protected String getText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append(UUID.randomUUID());
        }
        return sb.toString();
    }

    private /* synthetic */ void lambda$testRareAppenderLatency$4(ChronicleQueue queue, String text) {
        ExcerptAppender appender = queue.acquireAppender();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            try (DocumentContext ctx = appender.writingDocument();){
                ctx.wire().write(() -> "ts").int64(System.currentTimeMillis()).write(() -> "msg").text(text);
            }
            if (!this.appenderES.isShutdown()) continue;
            return;
        }
    }
}

