/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.compiler.CompilerUtils;
import org.jetbrains.annotations.NotNull;

public enum GeneratedProxyClass {

    static final boolean DUMP_CODE = Jvm.getBoolean("dumpCode");

    public static Class from(String packageName, Set<Class> interfaces, String className, ClassLoader classLoader) {
        int maxArgs = 0;
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>(16);
        StringBuilder sb = new StringBuilder("package " + packageName + ";\n\nimport net.openhft.chronicle.core.Jvm;\nimport net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;\nimport java.lang.reflect.InvocationHandler;\nimport java.lang.reflect.Method;\nimport java.util.stream.IntStream;\nimport java.util.ArrayList;\nimport java.util.List;\n");
        sb.append("public class ").append(className).append(" implements ");
        StringBuilder methodArray = new StringBuilder();
        int count = 0;
        String sep = "";
        for (Class interfaceClazz : interfaces) {
            sb.append(sep);
            String interfaceName = GeneratedProxyClass.nameForClass(interfaceClazz);
            sb.append(interfaceName);
            if (!interfaceClazz.isInterface()) {
                throw new IllegalArgumentException("expecting and interface instead of class=" + interfaceClazz.getName());
            }
            Method[] dms = interfaceClazz.getMethods();
            int n = dms.length;
            for (int i = 0; i < n; ++i) {
                Method dm = dms[i];
                if (dm.isDefault() || Modifier.isStatic(dm.getModifiers())) continue;
                if (dm.getGenericReturnType() instanceof TypeVariable) {
                    return null;
                }
                if (!methods.add(dm)) continue;
                maxArgs = Math.max(maxArgs, dm.getParameterCount());
                methodArray.append("\n    //").append(GeneratedProxyClass.createMethodSignature(dm, dm.getReturnType())).append("    methods[").append(count++).append("]=").append(interfaceName).append(".class.getMethods()[").append(i).append("];\n");
            }
            sep = ",\n              ";
        }
        sb.append(" {\n\n");
        GeneratedProxyClass.addFieldsAndConstructor(maxArgs, methods, sb, className, methodArray);
        GeneratedProxyClass.createProxyMethods(methods, sb);
        sb.append("}\n");
        if (DUMP_CODE) {
            System.out.println(sb);
        }
        try {
            return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, packageName + '.' + className, sb.toString());
        }
        catch (Throwable e) {
            throw Jvm.rethrow(new ClassNotFoundException(e.getMessage() + '\n' + sb, e));
        }
    }

    @NotNull
    private static String nameForClass(Class interfaceClazz) {
        return interfaceClazz.getName().replace('$', '.');
    }

    private static void addFieldsAndConstructor(int maxArgs, Set<Method> declaredMethods, StringBuilder sb, String className, StringBuilder methodArray) {
        sb.append("  private final MethodWriterInvocationHandlerSupplier handler;\n    private final Method[] methods = new Method[").append(declaredMethods.size()).append("];\n").append("  private static final int maxArgs = " + maxArgs + ";\n").append("  private final ThreadLocal<Object[][]> argsTL = ThreadLocal.withInitial(() -> IntStream.range(0, maxArgs + 1).mapToObj(Object[]::new).toArray(Object[][]::new));\n\n").append("  public ").append(className).append("(MethodWriterInvocationHandlerSupplier handler) {\n").append("    this.handler = handler;\n").append((CharSequence)methodArray).append("  }\n\n");
    }

    private static void createProxyMethods(Set<Method> declaredMethods, StringBuilder sb) {
        int methodIndex = -1;
        for (Method dm : declaredMethods) {
            Class<?> returnType = dm.getReturnType();
            sb.append(GeneratedProxyClass.createMethodSignature(dm, returnType));
            sb.append("    Method _method_ = this.methods[").append(++methodIndex).append("];\n");
            sb.append("    Object[] _a_ = this.argsTL.get()[").append(dm.getParameterCount()).append("];\n");
            GeneratedProxyClass.assignParametersToArgs(sb, dm);
            GeneratedProxyClass.callInvoke(sb, returnType);
        }
    }

    private static void callInvoke(StringBuilder sb, Class<?> returnType) {
        sb.append("    try {\n      ");
        if (returnType != Void.TYPE) {
            sb.append("return (").append(GeneratedProxyClass.nameForClass(returnType)).append(')');
        }
        sb.append(" handler.get().invoke(this,_method_,_a_);\n    } catch (Throwable throwable) {\n       throw Jvm.rethrow(throwable);\n    }\n  }\n");
    }

    private static void assignParametersToArgs(StringBuilder sb, Method dm) {
        int len = dm.getParameters().length;
        for (int j = 0; j < len; ++j) {
            String paramName = dm.getParameters()[j].getName();
            sb.append("    _a_[").append(j).append("] = ").append(paramName).append(";\n");
        }
    }

    private static CharSequence createMethodSignature(Method dm, Class<?> returnType) {
        int len = dm.getParameters().length;
        StringBuilder result = new StringBuilder();
        String typeName = GeneratedProxyClass.nameForClass(returnType);
        result.append("  public ").append(typeName).append(' ').append(dm.getName()).append('(');
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            String className = p.getType().getTypeName().replace('$', '.');
            result.append(className).append(' ').append(p.getName());
            if (j == len - 1) break;
            result.append(',');
        }
        result.append(") {\n");
        return result;
    }
}

