/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.batch.BatchAppender;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreAppender
extends AbstractCloseable
implements ExcerptAppender,
ExcerptContext,
InternalAppender {
    @NotNull
    private final SingleChronicleQueue queue;
    @NotNull
    private final WriteLock writeLock;
    @NotNull
    private final StoreAppenderContext context;
    private final WireStorePool storePool;
    private final boolean checkInterrupts;
    @Nullable
    SingleChronicleQueueStore store;
    private int cycle = Integer.MIN_VALUE;
    @Nullable
    private Wire wire;
    @Nullable
    private Wire wireForIndex;
    private long positionOfHeader = 0L;
    private long lastIndex = Long.MIN_VALUE;
    private long lastPosition;
    private int lastCycle;
    @Nullable
    private Pretoucher pretoucher = null;
    private NativeBytesStore<Void> batchTmp;
    private Wire bufferWire = null;
    private final Finalizer finalizer;

    StoreAppender(@NotNull SingleChronicleQueue queue, @NotNull WireStorePool storePool, boolean checkInterrupts) {
        this.queue = queue;
        this.storePool = storePool;
        this.checkInterrupts = checkInterrupts;
        this.writeLock = queue.writeLock();
        this.context = new StoreAppenderContext();
        queue.addCloseListener(this);
        queue.cleanupStoreFilesWithNoData();
        int cycle = queue.cycle();
        int lastCycle = queue.lastCycle();
        if (lastCycle != cycle && lastCycle >= 0) {
            this.setCycle2(lastCycle, false);
        }
        this.finalizer = Jvm.isResourceTracing() ? new Finalizer() : null;
    }

    private static void releaseBytesFor(Wire w) {
        if (w != null) {
            w.bytes().releaseLast();
        }
    }

    @Deprecated
    @NotNull
    WireStore store() {
        if (this.store == null) {
            this.setCycle(this.cycle());
        }
        return this.store;
    }

    @Override
    public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
        this.throwExceptionIfClosed();
        try (DocumentContext dc = this.writingDocument();){
            Bytes<?> bytes = dc.wire().bytes();
            long wp = bytes.writePosition();
            marshallable.writeMarshallable(bytes);
            if (wp == bytes.writePosition()) {
                dc.rollbackOnClose();
            }
        }
    }

    @Override
    protected void performClose() {
        StoreAppender.releaseBytesFor(this.wireForIndex);
        StoreAppender.releaseBytesFor(this.wire);
        StoreAppender.releaseBytesFor(this.bufferWire);
        if (this.pretoucher != null) {
            this.pretoucher.close();
        }
        if (this.store != null) {
            this.storePool.closeStore(this.store);
            this.store = null;
        }
        this.storePool.close();
        this.pretoucher = null;
        this.wireForIndex = null;
        this.wire = null;
        this.bufferWire = null;
    }

    @Override
    public void pretouch() {
        this.throwExceptionIfClosed();
        try {
            if (this.pretoucher == null) {
                this.pretoucher = new Pretoucher(this.queue());
            }
            this.pretoucher.execute();
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
            Jvm.rethrow(e);
        }
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    @Override
    public long batchAppend(int timeoutMS, BatchAppender batchAppender) {
        this.throwExceptionIfClosed();
        long maxMsgSize = this.queue.blockSize() / 4L;
        long startTime = System.currentTimeMillis();
        long count = 0L;
        long lastIndex = -1L;
        do {
            int defaultIndexSpacing = this.queue.rollCycle().defaultIndexSpacing();
            Wire wire = this.wire();
            int writeCount = Math.min(131072, (int)((long)defaultIndexSpacing - (lastIndex & (long)(defaultIndexSpacing - 1)) - 1L));
            if (wire != null && writeCount > 0) {
                MappedBytes bytes = (MappedBytes)wire.bytes();
                long address = bytes.addressForWrite(bytes.writePosition());
                long bstart = bytes.start();
                long bcap = bytes.realCapacity();
                long canWrite = bcap - (bytes.writePosition() - bstart);
                long lengthCount = batchAppender.writeMessages(address, canWrite, writeCount);
                bytes.writeSkip((int)lengthCount);
                lastIndex += lengthCount >> 32;
                count += lengthCount >> 32;
                continue;
            }
            if (this.batchTmp == null) {
                this.batchTmp = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(maxMsgSize);
            }
            try (DocumentContext dc = this.writingDocument();){
                long lengthCount = batchAppender.writeMessages(this.batchTmp.addressForWrite(0L), maxMsgSize, 1);
                int len = (int)lengthCount;
                dc.wire().bytes().write(this.batchTmp, 4L, (long)(len - 4));
            }
            lastIndex = this.lastIndexAppended();
            ++count;
        } while (startTime + (long)timeoutMS > System.currentTimeMillis());
        return count;
    }

    @Override
    @Nullable
    public Wire wireForIndex() {
        return this.wireForIndex;
    }

    @Override
    public long timeoutMS() {
        return this.queue.timeoutMS;
    }

    void lastIndex(long index) {
        this.lastIndex = index;
    }

    @Override
    public boolean recordHistory() {
        return this.sourceId() != 0;
    }

    void setCycle(int cycle) {
        if (cycle != this.cycle) {
            this.setCycle2(cycle, true);
        }
    }

    private void setCycle2(int cycle, boolean createIfAbsent) {
        if (cycle < 0) {
            throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
        }
        SingleChronicleQueue queue = this.queue;
        SingleChronicleQueueStore oldStore = this.store;
        SingleChronicleQueueStore newStore = this.storePool.acquire(cycle, queue.epoch(), createIfAbsent, oldStore);
        if (newStore != oldStore) {
            this.store = newStore;
            if (oldStore != null) {
                this.storePool.closeStore(oldStore);
            }
        }
        this.resetWires(queue);
        this.cycle = cycle;
        if (this.store == null) {
            return;
        }
        assert (this.wire.startUse());
        this.wire.parent(this);
        this.wire.pauser(queue.pauserSupplier.get());
        this.resetPosition();
        queue.onRoll(cycle);
    }

    private void resetWires(@NotNull ChronicleQueue queue) {
        WireType wireType = queue.wireType();
        Wire oldw = this.wire;
        Wire wire = this.wire = this.store == null ? null : this.createWire(wireType);
        assert (this.wire != oldw || this.wire == null);
        StoreAppender.releaseBytesFor(oldw);
        Wire old = this.wireForIndex;
        Wire wire2 = this.wireForIndex = this.store == null ? null : this.createWire(wireType);
        assert (this.wire != old || this.wire == null);
        StoreAppender.releaseBytesFor(old);
    }

    private Wire createWire(@NotNull WireType wireType) {
        Wire w = (Wire)wireType.apply(this.store.bytes());
        if (this.store.dataVersion() > 0) {
            w.usePadding(true);
        }
        return w;
    }

    private void resetPosition() throws UnrecoverableTimeoutException {
        try {
            if (this.store == null || this.wire == null) {
                return;
            }
            long position = this.store.writePosition();
            this.position(position, position);
            Bytes<?> bytes = this.wire.bytes();
            assert (!SingleChronicleQueue.CHECK_INDEX || this.checkPositionOfHeader(bytes));
            long headerNumber = this.store.lastSequenceNumber(this);
            this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber + 1L) - 1L);
            assert (!SingleChronicleQueue.CHECK_INDEX || this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.positionOfHeader));
            bytes.writeLimit(bytes.capacity());
        }
        catch (StreamCorruptedException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        assert (!SingleChronicleQueue.CHECK_INDEX || this.checkWritePositionHeaderNumber());
    }

    private boolean checkPositionOfHeader(Bytes<?> bytes) {
        if (this.positionOfHeader == 0L) {
            return true;
        }
        int header = bytes.readVolatileInt(this.positionOfHeader);
        return Wires.isReadyData(header) || Wires.isNotComplete(header);
    }

    @Override
    @NotNull
    public DocumentContext writingDocument() throws UnrecoverableTimeoutException {
        return this.writingDocument(false);
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.throwExceptionIfClosed();
        if (this.queue.doubleBuffer && this.writeLock.locked() && !metaData) {
            this.context.isClosed = false;
            this.context.rollbackOnClose = false;
            this.context.buffered = true;
            if (this.bufferWire == null) {
                OnHeapBytes bufferBytes = Bytes.allocateElasticOnHeap();
                this.bufferWire = (Wire)this.queue().wireType().apply(bufferBytes);
            }
            this.context.wire = this.bufferWire;
            this.context.metaData(false);
        } else {
            this.writeLock.lock();
            int cycle = this.queue.cycle();
            if (this.wire == null) {
                this.setWireIfNull(cycle);
            }
            if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            int safeLength = (int)this.queue.overlapSize();
            this.resetPosition();
            assert (!SingleChronicleQueue.CHECK_INDEX || this.checkWritePositionHeaderNumber());
            this.openContext(metaData, safeLength);
        }
        return this.context;
    }

    private void setWireIfNull(int cycle) {
        int lastCycle = this.queue.lastCycle();
        if (lastCycle == Integer.MIN_VALUE) {
            lastCycle = cycle;
        } else {
            int firstCycle = this.queue.firstCycle();
            for (int cur = lastCycle - 1; cur >= firstCycle; --cur) {
                this.setCycle2(cur, false);
                if (this.wire != null && !this.store.writeEOF(this.wire, this.timeoutMS())) break;
            }
        }
        this.setCycle2(lastCycle, true);
    }

    private long writeHeader(@NotNull Wire wire, int safeLength) {
        Bytes<?> bytes = wire.bytes();
        long pos = this.positionOfHeader;
        long lastPos = this.store.writePosition();
        if (pos < lastPos) {
            try {
                wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, this.store.lastSequenceNumber(this)));
            }
            catch (StreamCorruptedException ex) {
                Jvm.warn().on(this.getClass(), "Couldn't find last sequence", ex);
            }
        }
        int header = bytes.readVolatileInt(lastPos);
        assert (header != 0);
        lastPos += (long)(Wires.lengthOf(bytes.readVolatileInt(lastPos)) + 4);
        bytes.writePosition(lastPos);
        return wire.enterHeader(safeLength);
    }

    private void openContext(boolean metaData, int safeLength) {
        assert (this.wire != null);
        this.positionOfHeader = this.writeHeader(this.wire, safeLength);
        this.context.isClosed = false;
        this.context.rollbackOnClose = false;
        this.context.buffered = false;
        this.context.wire = this.wire;
        this.context.metaData(metaData);
    }

    boolean checkWritePositionHeaderNumber() {
        if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
            return true;
        }
        try {
            long pos = this.positionOfHeader;
            long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
            long seq2 = this.store.sequenceForPosition(this, pos, true);
            if (seq1 != seq2) {
                String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + " pos: " + pos + " header: " + this.wire.headerNumber() + " seq1: " + seq1 + " seq2: " + seq2;
                AssertionError ae = new AssertionError((Object)message);
                ((Throwable)((Object)ae)).printStackTrace();
                throw ae;
            }
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), e);
            throw Jvm.rethrow(e);
        }
        return true;
    }

    @Override
    public int sourceId() {
        return this.queue.sourceId;
    }

    @Override
    public void writeBytes(@NotNull BytesStore bytes) throws UnrecoverableTimeoutException {
        this.throwExceptionIfClosed();
        this.writeLock.lock();
        try {
            int cycle = this.queue.cycle();
            if (this.wire == null) {
                this.setWireIfNull(cycle);
            }
            if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            this.positionOfHeader = this.writeHeader(this.wire, (int)this.queue.overlapSize());
            assert (((AbstractWire)this.wire).isInsideHeader());
            this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
            Bytes<?> wireBytes = this.wire.bytes();
            wireBytes.write(bytes);
            this.wire.updateHeader(this.positionOfHeader, false, 0);
            this.lastIndex(this.wire.headerNumber());
            this.lastPosition = this.positionOfHeader;
            this.lastCycle = cycle;
            this.store.writePosition(this.positionOfHeader);
            this.writeIndexForPosition(this.lastIndex, this.positionOfHeader);
        }
        catch (StreamCorruptedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(long index, @NotNull BytesStore bytes) {
        this.throwExceptionIfClosed();
        this.writeLock.lock();
        try {
            this.writeBytesInternal(index, bytes);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void writeBytesInternal(long index, @NotNull BytesStore bytes) {
        this.writeBytesInternal(index, bytes, false);
    }

    protected void writeBytesInternal(long index, @NotNull BytesStore bytes, boolean metadata) {
        boolean rollbackDontClose;
        int cycle = this.queue.rollCycle().toCycle(index);
        if (this.wire == null) {
            this.setCycle2(cycle, true);
        } else if (this.cycle < cycle) {
            this.rollCycleTo(cycle);
        }
        boolean bl = rollbackDontClose = index != this.wire.headerNumber() + 1L;
        if (rollbackDontClose) {
            if (index > this.wire.headerNumber() + 1L) {
                throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue, current: " + Long.toHexString(this.wire.headerNumber()));
            }
            Jvm.warn().on(this.getClass(), "Trying to overwrite index " + Long.toHexString(index) + " which is before the end of the queue");
            return;
        }
        this.writeBytesInternal(bytes, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytesInternal(@NotNull BytesStore bytes, boolean metadata) {
        assert (this.writeLock.locked());
        try {
            int safeLength = (int)this.queue.overlapSize();
            this.openContext(metadata, safeLength);
            try {
                this.context.wire().bytes().write(bytes);
            }
            finally {
                this.context.close(false);
            }
        }
        finally {
            this.context.isClosed = true;
        }
    }

    private void position(long position, long startOfMessage) {
        if (position > this.store.writePosition() + this.queue.blockSize()) {
            throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
        }
        this.position0(position, startOfMessage);
    }

    @Override
    public long lastIndexAppended() {
        if (this.lastIndex != Long.MIN_VALUE) {
            return this.lastIndex;
        }
        if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
            throw new IllegalStateException("nothing has been appended, so there is no last index");
        }
        try {
            long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
            long index = this.queue.rollCycle().toIndex(this.lastCycle, sequenceNumber);
            this.lastIndex(index);
            return index;
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
    }

    @Override
    public int cycle() {
        if (this.cycle == Integer.MIN_VALUE) {
            int cycle = this.queue.lastCycle();
            if (cycle < 0) {
                cycle = this.queue.cycle();
            }
            return cycle;
        }
        return this.cycle;
    }

    @Override
    @NotNull
    public SingleChronicleQueue queue() {
        return this.queue;
    }

    void beforeAppend(Wire wire, long index) {
    }

    private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
        if (this.cycle == cycle) {
            throw new AssertionError();
        }
        this.store.writeEOF(this.wire, this.timeoutMS());
        int lastCycle = this.queue.lastCycle();
        if (lastCycle < cycle && lastCycle != this.cycle) {
            this.setCycle2(lastCycle, false);
            this.rollCycleTo(cycle);
        } else {
            this.setCycle2(cycle, true);
        }
    }

    void writeEndOfCycleIfRequired() {
        if (this.wire != null && this.queue.cycle() != this.cycle) {
            this.store.writeEOF(this.wire, this.timeoutMS());
        }
    }

    void writeIndexForPosition(long index, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
        this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
    }

    boolean checkIndex(long index, long position) {
        try {
            long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
            long seq2 = this.store.sequenceForPosition(this, position, true);
            if (seq1 != seq2) {
                long seq3 = this.store.indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                System.out.println("Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                System.out.println(this.store.dump());
                assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
            }
        }
        catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @Override
    public String toString() {
        return "StoreAppender{queue=" + this.queue + ", cycle=" + this.cycle + ", position=" + this.positionOfHeader + ", lastIndex=" + this.lastIndex + ", lastPosition=" + this.lastPosition + ", lastCycle=" + this.lastCycle + '}';
    }

    void position0(long position, long startOfMessage) {
        this.positionOfHeader = position;
        this.wire.bytes().writePosition(startOfMessage);
    }

    class StoreAppenderContext
    implements DocumentContext {
        boolean isClosed;
        private boolean metaData = false;
        private boolean rollbackOnClose = false;
        private boolean buffered = false;
        @Nullable
        private Wire wire;

        StoreAppenderContext() {
        }

        @Override
        public int sourceId() {
            return StoreAppender.this.sourceId();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Wire wire() {
            return this.wire;
        }

        @Override
        public boolean isMetaData() {
            return this.metaData;
        }

        @Override
        public void metaData(boolean metaData) {
            this.metaData = metaData;
        }

        @Override
        public void rollbackOnClose() {
            this.rollbackOnClose = true;
        }

        @Override
        public void close() {
            this.close(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close(boolean unlock) {
            block23: {
                block22: {
                    if (this.isClosed) {
                        Jvm.warn().on(this.getClass(), "Already Closed, close was called twice.");
                        return;
                    }
                    try {
                        boolean interrupted;
                        boolean bl = interrupted = StoreAppender.this.checkInterrupts && Thread.currentThread().isInterrupted();
                        if (this.rollbackOnClose || interrupted) {
                            this.doRollback(interrupted);
                            return;
                        }
                        if (this.wire == StoreAppender.this.wire) {
                            try {
                                this.wire.updateHeader(StoreAppender.this.positionOfHeader, this.metaData, 0);
                            }
                            catch (IllegalStateException e) {
                                if (!StoreAppender.this.queue.isClosed()) throw e;
                                if (!unlock) return;
                                try {
                                    StoreAppender.this.writeLock.unlock();
                                    return;
                                }
                                catch (Exception ex) {
                                    Jvm.warn().on(this.getClass(), "Exception while unlocking: ", ex);
                                }
                                return;
                            }
                            StoreAppender.this.lastPosition = StoreAppender.this.positionOfHeader;
                            break block22;
                        }
                        if (this.wire == null) return;
                        break block23;
                    }
                    catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                        throw new IllegalStateException(e);
                    }
                }
                StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                if (this.metaData) return;
                StoreAppender.this.lastIndex(this.wire.headerNumber());
                StoreAppender.this.store.writePosition(StoreAppender.this.positionOfHeader);
                if (StoreAppender.this.lastIndex == Long.MIN_VALUE) return;
                StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.positionOfHeader);
                return;
            }
            if (this.buffered) {
                StoreAppender.this.writeBytes(this.wire.bytes());
                return;
            }
            this.isClosed = true;
            StoreAppender.this.writeBytesInternal(this.wire.bytes(), this.metaData);
            this.wire = StoreAppender.this.wire;
            return;
            finally {
                if (unlock) {
                    try {
                        StoreAppender.this.writeLock.unlock();
                    }
                    catch (Exception ex) {
                        Jvm.warn().on(this.getClass(), "Exception while unlocking: ", ex);
                    }
                }
            }
        }

        private void doRollback(boolean interrupted) {
            if (interrupted) {
                Jvm.warn().on(this.getClass(), "Thread is interrupted. Can't guarantee complete message, so not committing");
            }
            for (long i = StoreAppender.this.positionOfHeader; i <= this.wire.bytes().writePosition(); ++i) {
                this.wire.bytes().writeByte(i, (byte)0);
            }
            long lastPosition = StoreAppender.this.lastPosition;
            StoreAppender.this.position0(lastPosition, lastPosition);
            ((AbstractWire)this.wire).forceNotInsideHeader();
        }

        @Override
        public long index() throws IORuntimeException {
            if (this.wire.headerNumber() == Long.MIN_VALUE) {
                try {
                    this.wire.headerNumber(StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.lastSequenceNumber(StoreAppender.this)));
                    long headerNumber0 = this.wire.headerNumber();
                    assert (((AbstractWire)this.wire).isInsideHeader());
                    return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
        }

        @Override
        public boolean isNotComplete() {
            throw new UnsupportedOperationException();
        }
    }

    private class Finalizer {
        private Finalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            StoreAppender.this.warnAndCloseIfNotClosed();
        }
    }
}

