/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class LastIndexAppendedTest
extends QueueTestCommon {
    @Test
    public void testLastIndexAppendedAcrossRestarts() {
        String path = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        for (int i = 0; i < 5; ++i) {
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                ExcerptAppender appender = queue.acquireAppender();
                try (DocumentContext documentContext = appender.writingDocument();){
                    int index = (int)documentContext.index();
                    Assert.assertEquals((long)i, (long)index);
                    documentContext.wire().write().text("hello world");
                }
                Assert.assertEquals((long)i, (long)((int)appender.lastIndexAppended()));
                continue;
            }
        }
        try {
            IOTools.deleteDirWithFiles((String)path, (int)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTwoAppenders() {
        long a_index;
        File path = DirectoryUtils.tempDir("testTwoAppenders");
        try (SingleChronicleQueue appender_queue = SingleChronicleQueueBuilder.single((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = appender_queue.acquireAppender();
            for (int i = 0; i < 5; ++i) {
                appender.writeDocument(wireOut -> wireOut.write((CharSequence)"log").marshallable(m -> m.write((CharSequence)"msg").text("hello world ")));
            }
            a_index = appender.lastIndexAppended();
        }
        var5_4 = null;
        try (SingleChronicleQueue tailer_queue = SingleChronicleQueueBuilder.single((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptTailer tailer = tailer_queue.createTailer();
            tailer = tailer.toStart();
            long t_index = this.doRead(tailer, 5);
            Assert.assertEquals((long)a_index, (long)t_index);
            try (SingleChronicleQueue appender_queue = SingleChronicleQueueBuilder.single((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                ExcerptAppender appender = appender_queue.acquireAppender();
                for (int i = 0; i < 5; ++i) {
                    appender.writeDocument(wireOut -> wireOut.write((CharSequence)"log").marshallable(m -> m.write((CharSequence)"msg").text("hello world2 ")));
                }
                a_index = appender.lastIndexAppended();
                Assert.assertTrue((a_index > t_index ? 1 : 0) != 0);
            }
            t_index = this.doRead(tailer, 5);
            Assert.assertEquals((long)a_index, (long)t_index);
            tailer.toStart();
            t_index = this.doRead(tailer, 10);
            Assert.assertEquals((long)a_index, (long)t_index);
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        try {
            IOTools.deleteDirWithFiles((File)path, (int)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long doRead(@NotNull ExcerptTailer tailer, int expected) {
        int[] i = new int[]{0};
        long t_index = 0L;
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) break;
                t_index = tailer.index();
                dc.wire().read("log").marshallable(m -> {
                    String msg = m.read("msg").text();
                    Assert.assertNotNull((Object)msg);
                    i[0] = i[0] + 1;
                });
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expected, (long)i[0]);
        return t_index;
    }
}

