/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;

public class ReferenceCountedCache<K, T extends ReferenceCounted & Closeable, V, E extends Throwable>
extends AbstractCloseable {
    private final Map<K, T> cache = new LinkedHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;
    private final Runnable bgCleanup = this::bgCleanup;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator) {
        this.transformer = transformer;
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    V get(@NotNull K key) throws E {
        ReferenceCounted value;
        Map<K, T> map = this.cache;
        synchronized (map) {
            this.throwExceptionIfClosed();
            value = (ReferenceCounted)this.cache.get(key);
            if (value != null && value.refCount() == 0) {
                ((Closeable)((Object)value)).close();
            }
            if (value == null || ((QueryCloseable)((Object)value)).isClosed()) {
                value = (ReferenceCounted)this.creator.apply(key);
                value.reserveTransfer(INIT, this);
                this.cache.put(key, value);
            }
        }
        BackgroundResourceReleaser.run(this.bgCleanup);
        return this.transformer.apply(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performClose() {
        Map<K, T> map = this.cache;
        synchronized (map) {
            for (ReferenceCounted value : this.cache.values()) {
                try {
                    value.release(this);
                }
                catch (Exception e) {
                    Jvm.debug().on(this.getClass(), e);
                }
            }
        }
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bgCleanup() {
        Map<K, T> map = this.cache;
        synchronized (map) {
            this.cache.entrySet().removeIf(entry -> ((ReferenceCounted)entry.getValue()).refCount() == 0);
        }
    }
}

