/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Test;

public class Stackoveflow52274284Test {
    @Test
    public void fails() throws Exception {
        String basePath = OS.TARGET;
        String path = Files.createTempDirectory(Paths.get(basePath, new String[0]), "chronicle-", new FileAttribute[0]).toAbsolutePath().toString();
        System.out.printf("Using temp path '%s'%n", path);
        try (SingleChronicleQueue chronicleQueue = ChronicleQueue.singleBuilder((String)path).testBlockSize().build();){
            Throwable throwable;
            int i;
            ExcerptAppender appender = chronicleQueue.acquireAppender();
            ExcerptTailer tailer = chronicleQueue.createTailer();
            tailer.toStart();
            int numberOfRecords = 10;
            for (i = 0; i <= numberOfRecords; ++i) {
                System.out.println("Writing " + i);
                try {
                    throwable = null;
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().write(() -> "msg").text("Hello World!");
                        System.out.println("your data was store to index=" + dc.index());
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    System.err.println("Unable to store value to chronicle");
                    e.printStackTrace();
                }
            }
            for (i = 0; i <= numberOfRecords; ++i) {
                System.out.println("Reading " + i);
                throwable = null;
                try (DocumentContext documentContext = tailer.readingDocument();){
                    long currentOffset = documentContext.index();
                    System.out.println("Current offset: " + currentOffset);
                    Wire wire = documentContext.wire();
                    if (wire == null) continue;
                    String msg = wire.read("msg").text();
                    System.out.println(msg);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }
}

